DROP TABLE contractor;

CREATE TABLE `contractor` (
  `id` int(3) NOT NULL AUTO_INCREMENT,
  `name` varchar(25) NOT NULL,
  `phone` bigint(12) NOT NULL,
  `address` varchar(45) NOT NULL,
  `bank_details` varchar(45) NOT NULL,
  `other_details` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE estimates;

CREATE TABLE `estimates` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `project_id` int(3) NOT NULL,
  `project_name` varchar(40) NOT NULL,
  `work_type_id` int(3) NOT NULL,
  `work_type_name` varchar(40) NOT NULL,
  `estimate` float NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

INSERT INTO estimates VALUES("2","1","XYZ Project","1","SAND","37500");
INSERT INTO estimates VALUES("3","1","XYZ Project","2","CEMENT","86000");



DROP TABLE expenses;

CREATE TABLE `expenses` (
  `id` int(7) NOT NULL AUTO_INCREMENT,
  `project` int(3) NOT NULL,
  `floor_no` varchar(15) NOT NULL,
  `flat_no` varchar(10) NOT NULL,
  `date` date NOT NULL,
  `work_type` varchar(50) NOT NULL,
  `amount` float NOT NULL,
  `particulars` varchar(100) NOT NULL,
  `reference` varchar(50) NOT NULL,
  `comments` varchar(100) NOT NULL,
  `rcptphoto` varchar(60) NOT NULL,
  `payment_method` enum('cash','cheque','bank transfer') NOT NULL,
  `payment_details` varchar(50) NOT NULL,
  `name` varchar(30) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9462 DEFAULT CHARSET=latin1;

INSERT INTO expenses VALUES("8809","1","","","2017-06-03","97","10000","Mazhar Painter labour payment.","","","","cheque","3120","Mazhar");
INSERT INTO expenses VALUES("8810","1","","","2017-06-12","97","6500","Paid labor payment to Mazhar.","","","","cheque","Cheque No. 3129","Mazhar");
INSERT INTO expenses VALUES("8811","1","","","2017-06-15","97","13000","Rs 10000/- paid by and Rs 3000 paid by cash. Total 13000/- labour payment paid to mazhar","","","","cheque","Cheque No. 3136","Mazhar");
INSERT INTO expenses VALUES("8812","1","","","2017-06-20","97","25000","Weekly Labour payment made to Mazhar.","","","","cheque","Cheque No. 3202","Mazhar");
INSERT INTO expenses VALUES("8813","1","","","2017-08-16","97","19000","Labor payment.","","","","cheque","Cheque No. 3220","Mazhar");
INSERT INTO expenses VALUES("8814","1","","","2017-08-19","97","13000","Labor payment","","","","cheque","Cheque No. 3224","Mazhar");
INSERT INTO expenses VALUES("8815","1","","","2017-08-24","97","8000","Labor Payment.","","","","cheque","Cheque No. 3230","Mazhar");
INSERT INTO expenses VALUES("8816","1","","","2017-09-01","97","5000","Paid mazhar Rs 15000/- out of which Rs 10000 Paid for murad Nagar work and Rs 5000 paid for tolichow","","","","cheque","Cheque No. 3235","Mazhar");
INSERT INTO expenses VALUES("8817","1","","","2017-10-21","97","10000","Labor payment.","","","","cheque","Cheque No. 3285","Mazhar");
INSERT INTO expenses VALUES("8818","1","","","2017-10-27","97","10000","Labor Payment","","","","cheque","Cheque No. 3303","Mazhar");
INSERT INTO expenses VALUES("8819","1","","","2017-11-08","97","5500","Total withdraw from bank is Rs 15000 out of which 9500 paid for Murad Nagar work. and Rs 5500 for To","","","","cheque","Cheque No. 3324","Mazhar");
INSERT INTO expenses VALUES("8820","1","","","2017-11-15","97","18000","Labor Payment.","","","","cheque","Cheque No. 3332","Mazhar");
INSERT INTO expenses VALUES("8821","1","","","2017-11-21","97","21000","Labor Payment","","","","cheque","Cheque No. 3341","Mazhar");
INSERT INTO expenses VALUES("8822","1","","","2017-12-01","97","25000","Labor Payment","","","","cheque","Cheque No. 3352","Mazhar");
INSERT INTO expenses VALUES("8823","1","","","2017-12-08","97","13000","Labor Payment.","","","","cheque","Cheque No. 3362","Mazhar");
INSERT INTO expenses VALUES("8824","1","","","2017-12-30","97","15000","Labour Payment.","","","","cheque","Cheque No. 3375","Mazhar");
INSERT INTO expenses VALUES("8825","1","","","2018-01-10","98","2000","Paid for tree cutting in front side. ","","","","cash","","Yousuf");
INSERT INTO expenses VALUES("8826","1","","","2018-01-10","18","10000","chipping of pent house and goa making. Total paid 10000/- for both work.","","","","cheque","Cheque No. 338","Shiva");
INSERT INTO expenses VALUES("8827","1","","","2018-01-10","9","41000","Paid to trupatty on behalf of senu for tank slap and wall putting labor charges.","","","","cheque","Cheque No. 3378","Trupatty Swamy");
INSERT INTO expenses VALUES("8828","1","","","2018-01-10","10","37500","Labor payment ","","","","cheque"," 3377","Trupatty Swamy");
INSERT INTO expenses VALUES("8829","1","","","2018-01-10","2","58000","Purchase cement 200 bags @ 290 per bag and made payment ","","","","cheque","3381","Junaid");
INSERT INTO expenses VALUES("8830","1","","","2018-01-11","99","10000","Paid for piping work at penthouse for 2 flats.","","","","cheque","Cheque No. 3383","Yousuf");
INSERT INTO expenses VALUES("8831","1","","","2018-01-11","120","9000","Watchman salary paid for the month of December 2017.","","","","cheque","Cheque No. 3384","Ramesh");
INSERT INTO expenses VALUES("8832","1","","","2018-01-11","100","50000","Paid to shareef for purchase of matterial and sheet for 5 floor flats.","","","","cheque","Cheque No. 3385","Shareef");
INSERT INTO expenses VALUES("8833","1","","","2018-01-12","1","49000","sand purchase on 8 & 11 Jan 18. total 2 load bill paid.","","","","cheque","Cheque No. 3386","Venkateshwarlu");
INSERT INTO expenses VALUES("8834","1","","","2018-01-12","97","12000","Paid labor payment.","","","","cheque","Cheque No. 3388","Mazhar");
INSERT INTO expenses VALUES("8836","1","","","2018-01-12","77","50000","Paid to yousuf for purchase of wire 720 for lobby wiring. cheque was issue on Mukesh name.","","","","cheque","Cheque No. 3390","Yousuf ");
INSERT INTO expenses VALUES("8837","1","","","2017-03-10","99","84000","Total amount paid for piping of slabs @ Rs 14000/- per slab. Total 6 slabs.","","","","cash","","Yousuf");
INSERT INTO expenses VALUES("8838","1","","","2017-04-07","99","72000","Total 18 flats wall piping done and paid Rs 4000 per flat.","","","","cash","","Yousuf");
INSERT INTO expenses VALUES("8839","1","","","2017-04-21","99","20000","Labor payment paid for flats wall piping.","","","","cash","","Yousuf");
INSERT INTO expenses VALUES("8840","1","","","2017-05-20","99","8000","Labor payment.","","","","cash","","Yousuf");
INSERT INTO expenses VALUES("8841","1","","","2017-05-23","99","4000","Labor payment.","","","","cash","","Yousuf");
INSERT INTO expenses VALUES("8842","1","","","2017-05-27","99","4000","Labor payment.","","","","cash","","Yousuf");
INSERT INTO expenses VALUES("8843","1","","","2017-05-28","99","5000","Work done for lobby piping.","","","","cash","","Yousuf");
INSERT INTO expenses VALUES("8844","1","","","2017-06-12","99","7500","Work done for lobby piping.","","","","cheque","3126","Yousuf");
INSERT INTO expenses VALUES("8845","1","","","2017-06-23","99","5000","Labor payment.","","","","cash","","Yousuf");
INSERT INTO expenses VALUES("8846","1","","","2017-07-11","99","5000","Labor payment.","","","","cash","","Yousuf");
INSERT INTO expenses VALUES("8847","1","","","2017-07-15","99","5000","Labor payment.","","","","cash","","Yousuf");
INSERT INTO expenses VALUES("8848","1","","","2017-07-20","99","20000","Labor payment.","","","","cheque","3174","Yousuf");
INSERT INTO expenses VALUES("8849","1","","","2017-08-24","99","34000","Full & Final payment done for wall piping. Rs 17000 + Advance taken by yousuf + first floor wiring d","","","","cheque","Cheque No. 3232","Yousuf");
INSERT INTO expenses VALUES("8850","1","","","2017-09-16","99","18000","3 floor 6 flats wiring done.","","","","cheque","Cheque No. 3252","Yousuf");
INSERT INTO expenses VALUES("8851","1","","","2017-09-29","99","27000","9 flats wiring done.","","","","cheque","Cheque No. 3259","Yousuf");
INSERT INTO expenses VALUES("8852","1","","","2017-10-27","99","10000","Labor payment.","","","","cheque","Cheque No. 3305","Yousuf");
INSERT INTO expenses VALUES("8853","1","","","2017-11-03","99","23000","11 flats wiring done. paid payment.","","","","cheque","Cheque No. 3316","Yousuf");
INSERT INTO expenses VALUES("8854","1","","","2017-11-17","99","15000","5 flats wiring done amount paid.","","","","cheque","Cheque No. 3340","Yousuf");
INSERT INTO expenses VALUES("8855","1","","","2017-11-29","99","15000","Cheque withdraw on SELF of amount Rs 20000. out of which rs 5000 take by azeem","","","","cheque","Cheque No. 3347","Yousuf");
INSERT INTO expenses VALUES("8856","1","","","2018-01-17","1","10000","ssssssssssssssssssssssssssssssssss","","","","cheque","3120","azeem");
INSERT INTO expenses VALUES("8857","1","","","2018-01-17","95","11","ssssssssssss","","","","cheque","212","azeem");
INSERT INTO expenses VALUES("8858","1","","","2018-01-20","9","20000","Paid to Mahoob (sendrying) for tank work. This amount will be in Senu account.","","","","cheque","3398","Mahoob ");
INSERT INTO expenses VALUES("8859","1","","","2018-01-20","100","50000","Purchase of material and labor payment.","","","","cheque","3400","Yousuf");
INSERT INTO expenses VALUES("8860","1","","","2018-01-20","102","150000","Amount return to fzami as short of amount to pay insentive to nishant for the month of December 2017","","","","cheque","3399","Fzami");
INSERT INTO expenses VALUES("8862","1","","","2018-01-20","103","50000","Purchase of tiles for 1st flat that is 101 which is demo flat.","","","","cheque","3402","Patel");
INSERT INTO expenses VALUES("8863","1","","","2018-01-20","97","5000","Labor payment.","","","","cheque","3403","Mazhar");
INSERT INTO expenses VALUES("8865","1","","","2018-01-29","98","50000","DCM & labor payment for 2 days to bring tiles from Mehdi function hall.","","","","cheque","3404","Shafi & Azeem");
INSERT INTO expenses VALUES("8866","1","","","2018-03-24","104","10000","Paid weekly labor payment to kamal.","","","","cash","","Kamal");
INSERT INTO expenses VALUES("8867","1","","","2018-03-31","104","9000","Paid weekly labour payment.","","","","cash","","Kamal");
INSERT INTO expenses VALUES("8869","1","","","2018-04-07","104","15000","Paid weekly labour payment","","","","cheque","3601","Kamal");
INSERT INTO expenses VALUES("8871","1","","","2018-04-24","104","8000","Paid weekly labour payment","","","","cheque","3502","Kamal");
INSERT INTO expenses VALUES("8872","1","","","2018-02-03","108","15000","Paid weekly labour payment","","","","cash","","saddam");
INSERT INTO expenses VALUES("8873","1","","","2018-02-11","108","15000","Paid weeklly labour payment","","","","cash","","saddam");
INSERT INTO expenses VALUES("8874","1","","","2018-02-17","108","10000","paid weekly labour payment","","","","cash","","saddam");
INSERT INTO expenses VALUES("8875","1","","","2018-03-03","108","15000","Paid weekly labour payment","","","","cash","","saddam");
INSERT INTO expenses VALUES("8877","1","","","2018-03-10","108","20000","Paid weekly labour payment","","","","cash","","saddam");
INSERT INTO expenses VALUES("8878","1","","","2018-03-17","105","50000","Advance payment for 3 flats","","","","cash","","Mujahaid");
INSERT INTO expenses VALUES("8879","1","","","2018-03-21","105","15000","Material payment","","","","cash","","Mujahaid");
INSERT INTO expenses VALUES("8880","1","","","2018-03-28","105","15000","Labour payment","","","","cash","","Mujahaid");
INSERT INTO expenses VALUES("8881","1","","","2018-05-02","110","200000","Paid for lift purchase charges.","","","","cheque","3613","Rehan Sharief");
INSERT INTO expenses VALUES("8882","1","","","2018-05-02","111","700","Paid internet bill for the month of April 2018","","","","cash","","Country online");
INSERT INTO expenses VALUES("8883","1","","","2017-10-11","101","15000","Paid weekly labour payment","","","","cheque","3294","Jamal");
INSERT INTO expenses VALUES("8884","1","","","2017-10-07","101","10000","Paid weekly labour payment","","","","cheque","3272","Jamal");
INSERT INTO expenses VALUES("8885","1","","","2017-10-13","101","30000","Paid weekly labour payment","","","","cheque","3295","Jamal");
INSERT INTO expenses VALUES("8886","1","","","2017-10-21","101","15000","Paid weekly labour payment","","","","cheque","3286","Waseem");
INSERT INTO expenses VALUES("8887","1","","","2017-10-27","101","15000","Paid weekly labour payment","","","","cheque","3306","Jamal");
INSERT INTO expenses VALUES("8888","1","","","2017-11-07","101","20000","Paid weekly labour payment","","","","cheque","3322","Jamal");
INSERT INTO expenses VALUES("8889","1","","","2017-11-10","101","20000","Paid weekly labour payment","","","","cheque","3329","Jamal");
INSERT INTO expenses VALUES("8890","1","","","2017-12-23","101","10000","Paid weekly labour payment","","","","cash","","Waseem");
INSERT INTO expenses VALUES("8891","1","","","2018-01-12","101","15000","Paid weekly labour payment","","","","cheque","3389","Waseem");
INSERT INTO expenses VALUES("8892","1","","","2018-01-20","101","15000","Paid weekly labour payment","","","","cheque","3401","Jamal");
INSERT INTO expenses VALUES("8893","1","","","2018-01-29","101","10000","Paid weekly labour payment ","","","","cheque","3490","Jamal");
INSERT INTO expenses VALUES("8894","1","","","2018-02-17","101","10000","Paid weekly labour payment","","","","cheque","3479","Jamal");
INSERT INTO expenses VALUES("8895","1","","","2018-02-26","101","20000","Paid weekly labour payment ","","","","cheque","3470","Jamal");
INSERT INTO expenses VALUES("8896","1","","","2018-03-03","101","10000","Rs 10000 Paid labour payment to Jamaal & Rs 5000 used for other expenditure.","","","","cheque","3441","Jamal");
INSERT INTO expenses VALUES("8897","1","","","2018-03-23","101","10000","Paid weekly labour payment","","","","cheque","3495","Jamal");
INSERT INTO expenses VALUES("8898","1","","","2018-03-31","101","10000","Paid weekly labour payment","","","","cash","","Jamal");
INSERT INTO expenses VALUES("8899","1","","","2018-04-07","101","15000","Paid weekly labour payment","","","","cheque","3600","Jamal");
INSERT INTO expenses VALUES("8900","1","","","2018-04-14","101","15000","Paid weekly labour payment","","","","cash","","Jamal");
INSERT INTO expenses VALUES("8901","1","","","2018-04-29","101","10000","Paid weekly labour payment","","","","cash","","Waseem");
INSERT INTO expenses VALUES("8902","1","","","2018-04-04","104","4000","Paid weekly labour payment","","","","cash","","Kamal");
INSERT INTO expenses VALUES("8903","1","","","2018-04-14","104","10000","Paid weekly labour payment","","","","cash","","Kamal");
INSERT INTO expenses VALUES("8904","1","","","2017-08-16","100","50000","Paid for 2 flats work 101 &108","","","","cash","","Shareef");
INSERT INTO expenses VALUES("8905","1","","","2017-09-22","100","20000","Cash withdraw Rs 50000 from which Rs 20000 paid to shareef for 4 flats work. Rs 30000 used for other","","","","cheque","3292","Shareef");
INSERT INTO expenses VALUES("8906","1","","","2018-09-29","100","50000","Balance paid for 4 flats work","","","","cheque","3261","Shareef");
INSERT INTO expenses VALUES("8907","1","","","2017-10-16","100","30000","Paid weekly labour payment","","","","cheque","003299","Shareef");
INSERT INTO expenses VALUES("8908","1","","","2017-10-21","100","10000","Paid weekly labour payment","","","","cash","","Shareef");
INSERT INTO expenses VALUES("8909","1","","","2017-10-27","100","20000","Paid weekly labour payment","","","","cash","","Shareef");
INSERT INTO expenses VALUES("8910","1","","","2017-11-03","100","15000","Paid weekly labour payment","","","","cash","","Shareef");
INSERT INTO expenses VALUES("8911","1","","","2017-11-10","100","50000","For purchase of chanel","","","","cash","","Shareef");
INSERT INTO expenses VALUES("8912","1","","","2017-11-29","100","50000","Paid weekly labour payment","","","","cash","","Shareef");
INSERT INTO expenses VALUES("8913","1","","","2017-12-19","100","50000","For purchase of material","","","","cash","","Shareef");
INSERT INTO expenses VALUES("8914","1","","","2017-12-23","100","30000","Paid weekly labour payment","","","","cash","","Shareef");
INSERT INTO expenses VALUES("8915","1","","","2017-12-30","100","10000","Paid weekly labour payment","","","","cash","","Shareef");
INSERT INTO expenses VALUES("8916","1","","","2018-01-27","100","30000","For material &  weekly labour payment","","","","cash","","Shareef");
INSERT INTO expenses VALUES("8917","1","","","2018-01-28","100","15000","Paid weekly labour payment","","","","cash","","Shareef");
INSERT INTO expenses VALUES("8918","1","","","2018-01-29","100","1000","Machine purchase","","","","cash","","Shareef");
INSERT INTO expenses VALUES("8920","1","","","2018-02-01","100","15000","Cash withdraw from bank is Rs 16000 Paid weekly labour payment Rs 15000.","","","","cheque","3485","Shareef");
INSERT INTO expenses VALUES("8921","1","","","2018-02-03","100","49000","Material","","","","cheque","3408","Shareef");
INSERT INTO expenses VALUES("8922","1","","","2018-02-03","100","16000","Paid weekly labour payment","","","","cheque","3409","Shareef");
INSERT INTO expenses VALUES("8923","1","","","2018-02-16","100","30000","For material","","","","cheque","3430","Shareef");
INSERT INTO expenses VALUES("8924","1","","","2018-02-14","100","15000","Cash withdraw Rs 20000 but paid to shareef only Rs 15000 for material.","","","","cheque","3427","Shareef");
INSERT INTO expenses VALUES("8925","1","","","2018-02-17","100","20000","Paid weekly labour payment","","","","cheque","3481","Shareef");
INSERT INTO expenses VALUES("8926","1","","","2018-02-28","100","22000","Paid weekly labour payment","","","","cheque","3459","Shareef");
INSERT INTO expenses VALUES("8928","1","","","2018-02-18","100","10000","Paid weekly labour payment for pent house","","","","cash","","Shareef");
INSERT INTO expenses VALUES("8929","1","","","2017-04-08","89","20000","Paid weekly labour payment","","","","cash","","Ibrahim");
INSERT INTO expenses VALUES("8930","1","","","2017-04-15","89","5000","Paid weekly labour payment","","","","cash","","Ibrahim");
INSERT INTO expenses VALUES("8931","1","","","2017-06-17","89","14000","Paid Rs 10000 by cheque & Rs 4000 by cash","","","","cheque","3138","Ibrahim");
INSERT INTO expenses VALUES("8932","1","","","2017-07-07","89","10000","Rs 8000 paid on 8-7-17 & Rs 2000 paid on 13-7-17.","","","","cheque","3156","Ibrahim");
INSERT INTO expenses VALUES("8934","1","","","2017-07-21","89","10000","Paid weekly labour payment","","","","cheque","3176","Ibrahim");
INSERT INTO expenses VALUES("8935","1","","","2017-08-05","89","5000","Paid weekly labour payment","","","","cheque","3204","Ibrahim");
INSERT INTO expenses VALUES("8936","1","","","2017-08-19","89","15000","Paid weekly labour payment","","","","cheque","3229","Ibrahim");
INSERT INTO expenses VALUES("8937","1","","","2017-10-21","89","10000","Paid labour payment for Murad nagar work.","","","","cheque","3283","Ibrahim");
INSERT INTO expenses VALUES("8939","1","","","2017-12-06","89","8000","Paid weekly labour payment","","","","cash","","Ibrahim");
INSERT INTO expenses VALUES("8940","1","","","2018-02-01","89","25000","Rs 20000 paid by cheque & Rs 5000 paid by cash.","","","","cheque","3486","Ibrahim");
INSERT INTO expenses VALUES("8941","1","","","2018-03-17","89","10000","Paid weekly labour payment","","","","cash","","Ibrahim");
INSERT INTO expenses VALUES("8942","1","","","2018-03-31","89","20000","Paid weekly labour payment","","","","cash","","Ibrahim");
INSERT INTO expenses VALUES("8943","1","","","2018-04-07","89","10000","Paid weekly labour payment","","","","cheque","3599","Ibrahim");
INSERT INTO expenses VALUES("8944","1","","","2018-04-14","89","20000","Paid weekly labour payment. Full & final for bath room work","","","","cash","","Ibrahim");
INSERT INTO expenses VALUES("8945","1","","","2017-10-07","89","8000","Paid weekly labour payment","","","","cheque","3271","Ibrahim");
INSERT INTO expenses VALUES("8946","1","","","2017-03-24","112","6000","Paid weekly labour payment","","","","cheque","3063","Zaki");
INSERT INTO expenses VALUES("8947","1","","","2017-02-28","112","3000","Paid weekly labour payment","","","","cash","","Zaki");
INSERT INTO expenses VALUES("8948","1","","","2017-03-03","112","4000","Paid weekly labour payment","","","","cash","","Zaki");
INSERT INTO expenses VALUES("8949","1","","","2017-03-18","112","25000","Paid weekly labour payment","","","","cheque","3058","Zaki");
INSERT INTO expenses VALUES("8950","1","","","2017-04-01","112","16000","Paid weekly labour payment","","","","cash","","Zaki");
INSERT INTO expenses VALUES("8951","1","","","2017-04-08","112","8000","Paid weekly labour payment","","","","cash","","Zaki");
INSERT INTO expenses VALUES("8952","1","","","2017-04-15","112","5000","Paid weekly labour payment","","","","cash","","Zaki");
INSERT INTO expenses VALUES("8953","1","","","2017-05-20","112","12000","Paid weekly labour payment","","","","cash","","Zaki");
INSERT INTO expenses VALUES("8954","1","","","2017-06-13","112","10000","Paid weekly labour payment","","","","cheque","3130","Zaki");
INSERT INTO expenses VALUES("8955","1","","","2017-06-23","112","6000","Paid weekly labour payment","","","","cheque","3141","Zaki");
INSERT INTO expenses VALUES("8956","1","","","2017-07-14","112","5000","Paid weekly labour payment","","","","cheque","3165","Zaki");
INSERT INTO expenses VALUES("8957","1","","","2017-08-17","112","20000","Paid weekly labour payment","","","","cheque","3223","Zaki");
INSERT INTO expenses VALUES("8958","1","","","2017-08-19","112","8000","Paid weekly labour payment","","","","cheque","3227","Zaki");
INSERT INTO expenses VALUES("8960","1","","","2017-08-25","112","50000","Hospital charges","","","","cash","","Zaki");
INSERT INTO expenses VALUES("8963","1","","","2018-02-14","97","15000","Paid weekly labour payment","","","","cheque","3428","Mazher");
INSERT INTO expenses VALUES("8964","1","","","2017-02-17","97","30000","Paid weekly labour payment","","","","cheque","3478","Mazher");
INSERT INTO expenses VALUES("8965","1","","","2018-02-26","97","13000","Paid weekly labour payment","","","","cheque","3466","Mazher");
INSERT INTO expenses VALUES("8966","1","","","2018-03-07","97","10000","Paid weekly labour payment","","","","cheque","3593","Mazher");
INSERT INTO expenses VALUES("8967","1","","","2018-03-18","97","20000","Paid weekly labour payment at Mehdipatnam.","","","","cash","","Mazher");
INSERT INTO expenses VALUES("8968","1","","","2018-03-23","97","10000","Paid weekly labour payment","","","","cheque","3494","Mazher");
INSERT INTO expenses VALUES("8969","1","","","2018-02-17","99","20000","Paid weekly labour payment","","","","cheque","3480","Yousuf");
INSERT INTO expenses VALUES("8970","1","","","2018-03-25","99","10000","Paid weekly labour payment","","","","cash","","Yousuf");
INSERT INTO expenses VALUES("8971","1","","","2018-03-10","99","10000","Paid weekly labour payment","","","","cash","","Yousuf");
INSERT INTO expenses VALUES("8972","1","","","2018-04-28","104","5000","Paid Labor Payment","","","","cash","","Kamal");
INSERT INTO expenses VALUES("8973","1","","","2018-02-03","107","15000","Rs 15000 paid Labor Payment to saddam & Rs 1000 used for other expenditure. ","","","","cheque","3413","Saddam");
INSERT INTO expenses VALUES("8974","1","","","2018-02-09","107","15000","Labor Payment.","","","","cheque","3420","Saddam");
INSERT INTO expenses VALUES("8975","1","","","2018-02-17","107","10000","Labor Payment.","","","","cheque","3477","Saddam");
INSERT INTO expenses VALUES("8976","1","","","2018-03-03","107","15000","Labor Payment.","","","","cheque","3442","Saddam");
INSERT INTO expenses VALUES("8977","1","","","2018-03-10","107","20000","Labor Payment.","","","","cash","","Saddam");
INSERT INTO expenses VALUES("8978","1","","","2017-06-23","10","50000","Labor Payment.","","","","cheque","3142","Trupatty");
INSERT INTO expenses VALUES("8979","1","","","2017-06-24","10","7000","Bricks lifting charges","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("8980","1","","","2017-06-27","10","8000","Trupatty charges","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("8981","1","","","2017-07-01","10","65000","Labour payment + lifting charges + Trupatty charges","","","","cheque","3150","Trupatty");
INSERT INTO expenses VALUES("8982","1","","","2017-07-07","10","30000","Lifting charges + Trupatty charges","","","","cheque","3155","Trupatty");
INSERT INTO expenses VALUES("8983","1","","","2017-07-15","10","90000","2 weeks laboour payment + Trupatty charges.( 80000+10000 )","","","","cheque","3166  &  3169","Trupatty");
INSERT INTO expenses VALUES("8984","1","","","2017-07-21","10","50000","Labour payment","","","","cheque","3175","Trupatty");
INSERT INTO expenses VALUES("8985","1","","","2017-08-02","10","50000","Labour payment","","","","cheque","3189","Trupatty");
INSERT INTO expenses VALUES("8986","1","","","2017-08-05","10","20000","Lifting charges + Trupatty charges","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("8987","1","","","2017-08-05","10","45000","Lifting charges + Trupatty charges","","","","cheque","3208","Trupatty");
INSERT INTO expenses VALUES("8988","1","","","2017-08-11","10","12000","Lifting charges","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("8989","1","","","2017-08-11","10","200000","Advance ","","","","cheque","3214","Trupatty");
INSERT INTO expenses VALUES("8990","1","","","2017-08-19","10","40000","Labour payment + shifting charges","","","","cheque","3226","Trupatty");
INSERT INTO expenses VALUES("8991","1","","","2017-08-24","10","45000","Labour payment + shifting charges","","","","cheque","3231","Trupatty");
INSERT INTO expenses VALUES("8992","1","","","2017-09-09","10","60000","2 weeks labour payment + lifting charges","","","","cheque","3238","Trupatty");
INSERT INTO expenses VALUES("8993","1","","","2017-09-12","10","25000","Lifting charges + Trupatty charges","","","","cheque","3249","Trupatty");
INSERT INTO expenses VALUES("8994","1","","","2017-09-16","10","41000","Rs 23000 paid by cheque  & Rs 18000 paid b","","","","cheque","3253","Trupatty");
INSERT INTO expenses VALUES("8995","1","","","2017-09-23","10","20000","Labour payment","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("8996","1","","","2017-10-07","10","61000","Labour payment for 3 weeks. & Rs 52000 paid to Tirupathi.","","","","cheque","3275","Trupatty");
INSERT INTO expenses VALUES("8997","1","","","2017-10-14","10","30000","Labour payment + Trupatty charges","","","","cheque","003278","Trupatty");
INSERT INTO expenses VALUES("8998","1","","","2017-10-21","10","36000","Labour payment + Trupatty charges","","","","cheque","3287","Trupatty");
INSERT INTO expenses VALUES("8999","1","","","2017-10-27","10","30000","Labour payment + Trupatty charges","","","","cheque","3302","Trupatty");
INSERT INTO expenses VALUES("9000","1","","","2017-11-06","10","33000","Labour payment + Trupatty charges","","","","cheque","3319","Trupatty");
INSERT INTO expenses VALUES("9001","1","","","2017-11-10","10","24000","Labour payment + Labour payment for columns","","","","cheque","3330","Trupatty");
INSERT INTO expenses VALUES("9002","1","","","2017-11-29","10","10000","Trupatty Labour payment","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9003","1","","","2017-12-15","10","10000","Bricks lifting charges","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9004","1","","","2017-12-16","10","25000","Rethi lifting + Labour payment","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9005","1","","","2018-05-05","10","25000","Labour payment","","","","cheque","3616","Trupatty");
INSERT INTO expenses VALUES("9006","1","","","2017-12-22","10","36000","Labour payment + Bricks lifting","","","","cheque","3368","Trupatty");
INSERT INTO expenses VALUES("9007","1","","","2017-12-30","10","49000"," Rs 30000 Labour payment & remaining amt return back.","","","","cheque","3374","Trupatty");
INSERT INTO expenses VALUES("9009","1","","","2018-01-12","10","80000","Trupatty advance amt RS 50000 + Labour payment Rs 30000.","","","","cheque","3387","Trupatty");
INSERT INTO expenses VALUES("9010","1","","","2018-01-29","10","20000","Paid to Mahboob ( sendrying )","","","","cheque","3405","Trupatty");
INSERT INTO expenses VALUES("9011","1","","","2018-01-24","10","14000","Sand lifting charges","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9012","1","","","2018-02-03","10","30000","Labour payment","","","","cheque","3410","Trupatty");
INSERT INTO expenses VALUES("9013","1","","","2018-02-12","10","35000","Labour payment","","","","cheque","3425","Trupatty");
INSERT INTO expenses VALUES("9014","1","","","2018-02-17","10","25000","Labour payment","","","","cheque","3436","Trupatty");
INSERT INTO expenses VALUES("9015","1","","","2018-02-26","10","37000","Labour payment","","","","cheque","3468","Trupatty");
INSERT INTO expenses VALUES("9016","1","","","2018-03-03","10","20000","Rs 20000 paid Labour payment to Tirupathi & Rs 4000 used for other expenditure. ","","","","cheque","3591","Trupatty");
INSERT INTO expenses VALUES("9017","1","","","2018-03-10","10","41000","Labour payment","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9018","1","","","2018-03-10","10","8000","Sand lifting charges","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9019","1","","","2018-03-17","10","25000","Labour payment","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9020","1","","","2018-03-23","10","25000","Labour payment","","","","cheque","3497","Trupatty");
INSERT INTO expenses VALUES("9021","1","","","2018-03-28","10","10000","Advance Labour payment","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9022","1","","","2018-04-04","10","3500","Labour payment","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9023","1","","","2018-04-07","10","44000","Cheque was issue for amount of 60000/-. Labour payment was 44000 other charges like digging and mate","","","","cheque","3598","Trupatty");
INSERT INTO expenses VALUES("9024","1","","","2018-04-14","10","19000","Labour payment","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9025","1","","","2018-04-21","10","15000","Labour payment","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9026","1","","","2018-04-28","10","10000","Labour payment","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9027","1","","","2018-05-05","103","12000","Bathroom tiles purchase for 10 bathrooms. Rs 12000 paid in advance and rest Rs 30000/- by cheque on ","","","","cash","","Patel");
INSERT INTO expenses VALUES("9028","1","","","2018-05-05","113","21600","Granite 300 sq feet purchase for staircase landing. bill include of labor and transport. total withd","","","","cash","","Anil");
INSERT INTO expenses VALUES("9029","1","","","2016-10-26","10","90000","Labour payment","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9030","1","","","2016-11-29","10","50000","Labour payment","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9031","1","","","2016-12-27","10","50000","Labour payment","","","","cheque","2994","Trupatty");
INSERT INTO expenses VALUES("9032","1","","","2016-12-27","10","8000","Bricks lifting charges","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9033","1","","","2017-01-09","10","50000","Labour payment","","","","cheque","2999","Trupatty");
INSERT INTO expenses VALUES("9034","1","","","2017-01-07","10","30000","Labour payment","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9035","1","","","2017-01-14","10","50000","Labour payment","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9036","1","","","2017-01-21","10","50000","Labour payment","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9037","1","","","2017-01-21","10","3000","Bricks lifting charges","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9038","1","","","2017-01-21","10","8000","Material lifting charges","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9039","1","","","2017-01-28","10","50000","Labour payment","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9040","1","","","2017-02-03","10","50000","Labour payment","","","","cheque","3014","Trupatty");
INSERT INTO expenses VALUES("9041","1","","","2017-02-04","10","50000","Labour payment","","","","cheque","3013","Trupatty");
INSERT INTO expenses VALUES("9042","1","","","2017-02-11","10","45000","Labour payment","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9043","1","","","2017-02-18","10","45000","Labour payment","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9044","1","","","2017-02-26","10","80000","Labour payment ( Rs 50000 paid by cheque & Rs 30000 paid by cash )","","","","cheque","","Trupatty");
INSERT INTO expenses VALUES("9045","1","","","2017-03-04","10","50000","Labour payment","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9046","1","","","2017-03-04","10","7500","Material lifting charges","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9047","1","","","2017-03-04","10","20000","Labour payment","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9048","1","","","2017-03-11","10","58000","Labour payment","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9049","1","","","2017-03-11","10","8000","Rethi lifting charges","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9050","1","","","2017-03-11","10","8500","Bricks lifting charges","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9051","1","","","2017-03-11","10","5500","Labour payment","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9052","1","","","2017-03-21","10","50000","Labour payment","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9053","1","","","2017-03-20","10","19500","Material lifting charges","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9054","1","","","2017-03-22","10","12500","Labour payment","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9055","1","","","2017-03-25","10","56000","Labour payment","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9056","1","","","2017-03-27","10","50000","Labour payment","","","","cheque","3069","Trupatty");
INSERT INTO expenses VALUES("9057","1","","","2017-04-01","10","30000","Labour payment","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9058","1","","","2017-04-08","10","50000","Labour payment","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9059","1","","","2017-04-15","10","45000","Rs 18000 paid by cheque on 17-4-2018. Remaining amount paid by cash.","","","","cheque","3080","Trupatty");
INSERT INTO expenses VALUES("9060","1","","","2018-05-07","110","150000","Purchase of lift material","","","","cheque","003505","Rehan Sharief");
INSERT INTO expenses VALUES("9061","1","","","2018-05-07","103","30000","Balance payment for Tiles Purchase","","","","cheque","003506","Patel");
INSERT INTO expenses VALUES("9062","1","","","2017-04-25","10","50000","Labour payment","","","","cheque","3081","Trupatty");
INSERT INTO expenses VALUES("9063","1","","","2018-05-07","98","15000","Amount paid for 3D designing  brouchers","","","","cheque","003619","Trupatty");
INSERT INTO expenses VALUES("9064","1","","","2017-04-29","10","50000","Labour payment","","","","cheque","3089","Trupatty");
INSERT INTO expenses VALUES("9065","1","","","2017-05-06","10","50000","Labour payment","","","","cheque","3097","Trupatty");
INSERT INTO expenses VALUES("9066","1","","","2017-05-13","10","50000","Labour payment","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9067","1","","","2017-05-15","10","9000","Labour payment","","","","cheque","3108","Trupatty");
INSERT INTO expenses VALUES("9068","1","","","2017-05-20","10","50000","Labour payment","","","","cheque","3111","Trupatty");
INSERT INTO expenses VALUES("9069","1","","","2017-05-26","10","50000","Labour payment","","","","cheque","3112","Trupatty");
INSERT INTO expenses VALUES("9070","1","","","2017-05-27","10","8000","Material lifting charges","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9071","1","","","2017-06-03","10","50000","Labour payment","","","","cheque","3117","Trupatty");
INSERT INTO expenses VALUES("9072","1","","","2017-06-06","10","10000","Material lifting charges","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9073","1","","","2017-06-10","10","42000","Labour payment","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9074","1","","","2017-06-10","10","8000","Material lifting charges","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9075","1","","","2017-06-10","10","4000","Labour payment","","","","cash","","Trupatty");
INSERT INTO expenses VALUES("9076","1","","","2017-06-17","10","60000","Labour payment","","","","cheque","3140","Trupatty");
INSERT INTO expenses VALUES("9077","1","","","2016-08-01","11","400000","Paid amount for Ground floor slab. Total 117 Qubic Meter @ Rs 3500.","","","","cheque","2979","Sai Ram");
INSERT INTO expenses VALUES("9078","1","","","2016-08-12","11","400000","Paid amount for Ground floor slab. Total 117 Qubic Meter @ Rs 3500. Second payment.","","","","cheque","2981","Sai Ram");
INSERT INTO expenses VALUES("9079","1","","","2016-09-21","11","400000","Paid amount for slab. ","","","","cheque","2985","Sai Ram");
INSERT INTO expenses VALUES("9080","1","","","2016-12-05","11","300000","Amount paid for reddy mix slab.","","","","cash","","Sai Ram");
INSERT INTO expenses VALUES("9081","1","","","2017-02-20","11","200000","Paid amount for slab work to Rank Silicon. ","","","","cheque","3009","Sai Ram");
INSERT INTO expenses VALUES("9082","1","","","2017-02-04","11","200000","Amount paid for slab to Rank silicon.","","","","cheque","3008","Sai Ram");
INSERT INTO expenses VALUES("9083","1","","","2017-04-04","11","200000","Paid amount to Rank silicon for reddy mix slab.","","","","cheque","3010","Sai Ram");
INSERT INTO expenses VALUES("9084","1","","","2017-05-04","11","100000","Paid amount to Rank silicon for reddy mix slab.","","","","cheque","3095","Sai Ram");
INSERT INTO expenses VALUES("9085","1","","","2017-06-02","11","150000","Paid amount to Rank silicon for reddy mix.","","","","cheque","3193","Sai Ram");
INSERT INTO expenses VALUES("9086","1","","","2017-09-21","11","110000","full and final payment to rank silicon.","","","","cheque","3256","Sai Ram");
INSERT INTO expenses VALUES("9087","1","","","2017-02-06","14","62400","Transfer to NALLA VERRIYYA
\n","","","","cheque","3015","Babu");
INSERT INTO expenses VALUES("9088","1","","","2017-03-07","14","62725","TRFR TO:NALLA RAMBABU","","","","cheque","3045","Babu");
INSERT INTO expenses VALUES("9089","1","","","2017-03-16","14","63000","Transfer to VERRIYYA NALLA","","","","cheque","3055","Babu");
INSERT INTO expenses VALUES("9090","1","","","2017-01-24","77","20000","Purchase  material from Mukesh electricals","","","","cheque","3006","DEVA");
INSERT INTO expenses VALUES("9091","1","","","2017-02-06","77","22000","Purchase  material from Mukesh electricals","","","","cheque","3007","DEVA");
INSERT INTO expenses VALUES("9092","1","","","2017-03-17","77","22000","Purchase  material from Mukesh electricals","","","","cheque","3047","DEVA");
INSERT INTO expenses VALUES("9093","1","","","2017-02-08","2","42750","Purchase cement from INDIA STEEL ENTERPRISES","","","","cheque","3017","JUNAID");
INSERT INTO expenses VALUES("9094","1","","","2017-02-22","2","55000","Purchase cement from INDIA STEEL ENTERPRISES","","","","cheque","3036","JUNAID");
INSERT INTO expenses VALUES("9095","1","","","2017-03-10","2","53600","Purchase cement from INDIA STEEL ENTERPRISES","","","","cheque","","JUNAID");
INSERT INTO expenses VALUES("9096","1","","","2017-01-02","1","50000","Transfer to MALLE VENKATESHWARLU","","","","cheque","2993","VENKATESH");
INSERT INTO expenses VALUES("9097","1","","","2017-03-10","1","50000","Paid to MALLE VENKATESHWARLU ...","","","","cheque","3048","VENKATESH");
INSERT INTO expenses VALUES("9098","1","","","2017-03-16","1","40000","Paid to MALLE VENKATESHWARLU ...","","","","cheque","3024","VENKATESH");
INSERT INTO expenses VALUES("9099","1","","","2017-03-22","1","50000","Paid to MALLE VENKATESHWARLU ...","","","","cheque","3034","VENKATESH");
INSERT INTO expenses VALUES("9100","1","","","2017-03-14","1","10000","Paid to MALLE VENKATESHWARLU ...","","","","cheque","3054","VENKATESH");
INSERT INTO expenses VALUES("9101","1","","","2017-03-08","5","142122","Purchase sanitary material from SRI LAXMI SALES CORPORATI","","","","cheque","3042","SRI LAXMI SANITARY");
INSERT INTO expenses VALUES("9102","1","","","2017-02-06","114","200000","STEEL PURCHASE FROM KESHREE METALURGIES PVT L","","","","cheque","3016","KESHREE METAL");
INSERT INTO expenses VALUES("9103","1","","","2017-02-21","114","100000","STEEL PURCHASE FROM KESHREE METALURGIES PVT L","","","","cheque","3031","KESHREE METAL");
INSERT INTO expenses VALUES("9104","1","","","2017-03-16","114","83700","STEEL PURCHASE FROM KESHREE METALURGIES PVT L","","","","cheque","3052","KESHREE METAL");
INSERT INTO expenses VALUES("9105","1","","","2017-02-15","95","26217","Paid electricity bill
\n","","","","cheque","3019","Electricity bill ");
INSERT INTO expenses VALUES("9106","1","","","2017-01-30","115","288","Paid Tata Bills","","","","cash","","Phone Bill");
INSERT INTO expenses VALUES("9107","1","","","2017-03-08","115","1840","Paid Tata Bills","","","","bank transfer","","Phone Bill");
INSERT INTO expenses VALUES("9108","1","","","2017-02-16","116","3300","Paid to carpenter shabbir","","","","cheque","3026","Shabbir");
INSERT INTO expenses VALUES("9109","1","","","2017-02-22","116","50000","Paid to Shabbir
\n","","","","cheque","3032","Shabbir");
INSERT INTO expenses VALUES("9110","1","","","2017-03-14","116","50000","Paid to Shabbir
\n","","","","cheque","3056","Shabbir");
INSERT INTO expenses VALUES("9111","1","","","2017-03-20","116","31050","Paid to Sabbir","","","","cheque","3060","Shabbir");
INSERT INTO expenses VALUES("9112","1","","","2017-01-30","115","1004","Paid Tata Bills","","","","bank transfer","","Phone Bill");
INSERT INTO expenses VALUES("9113","1","","","2017-01-19","102","10000","TRFR TO:FZAMI ONLINE SERVICES","","","","cheque","3004","FZAMI ONLINE SERVICES");
INSERT INTO expenses VALUES("9114","1","","","2017-01-16","116","46000","CASH PAID:SHABBER AHMED	","","","","cheque","3002","Shabbir");
INSERT INTO expenses VALUES("9115","1","","","2017-01-12","114","70000","Paid to H S M Steels.
\n","","","","cheque","2998","HSM Steels");
INSERT INTO expenses VALUES("9116","1","","","2017-03-30","2","53600","Purchase cement from INDIA STEEL ENTERPRISES
\n","","","","cheque","3074","JUNAID");
INSERT INTO expenses VALUES("9117","1","","","2017-03-28","1","40000","Paid to VENKATESH","","","","cheque","3071","VENKATESH");
INSERT INTO expenses VALUES("9118","1","","","2017-03-29","14","90000","Transfer to VERRIYYA NALLA			
\n","","","","cheque","3064","Babu");
INSERT INTO expenses VALUES("9119","1","","","2017-03-31","95","14439","Paid Electricity Bill","","","","cheque","3068","Electricity bill ");
INSERT INTO expenses VALUES("9120","1","","","2018-05-11","101","15000","Paid two payment on a single day. paid labour payment.","","","","cheque","","Jamal");
INSERT INTO expenses VALUES("9121","1","","","2018-05-19","101","8000","Paid cash taken form advance of flat sale.","","","","cash","","Jamal");
INSERT INTO expenses VALUES("9123","1","","","2016-07-22","114","532454","Steel purchase from KESHREE METALURGIES PVT Ltd. ","","","","cheque","2976","KESHREE METAL");
INSERT INTO expenses VALUES("9124","1","","","2016-08-17","114","37000","Steel purchase from iqbal steel.","","","","cheque","2980","H S M STEELS");
INSERT INTO expenses VALUES("9125","1","","","2016-07-25","2","50000","Purchase of cement.","","","","cheque","2977","Ghouse");
INSERT INTO expenses VALUES("9126","1","","","2016-08-17","2","60000","Cheque issue on SELF. Purchase of cement. ","","","","cheque","2983","Ghouse");
INSERT INTO expenses VALUES("9127","1","","","2016-09-19","118","816","Bank charges debited from account.","","","","bank transfer","","Bankers");
INSERT INTO expenses VALUES("9128","1","","","2016-08-17","119","17500","Dont remember about this entry.","","","","cheque","2982","SWANTH RAJ");
INSERT INTO expenses VALUES("9129","1","","","2016-09-22","119","474283","Dont remember the entry.","","","","cheque","2984","VIBGYOR TECHNICAL SERVICES");
INSERT INTO expenses VALUES("9130","1","","","2016-07-15","118","287","Bank charges.","","","","bank transfer","","Bankers");
INSERT INTO expenses VALUES("9131","1","","","2016-11-22","115","410","Paid Land line bill.","","","","bank transfer","","Phone Bill");
INSERT INTO expenses VALUES("9132","1","","","2016-11-29","115","865","Paid Land line bill.","","","","bank transfer","","Phone Bill");
INSERT INTO expenses VALUES("9133","1","","","2016-12-31","115","2176","Land line bill paid.","","","","bank transfer","","Phone Bill");
INSERT INTO expenses VALUES("9134","1","","","2016-11-21","115","862","Land line bill paid","","","","bank transfer","","Phone Bill");
INSERT INTO expenses VALUES("9135","1","","","2016-10-15","114","362074","Steel purchase from KESHREE METALRGIES PLTD	","","","","cheque","2986","KESHREE METAL");
INSERT INTO expenses VALUES("9136","1","","","2016-12-23","1","50000","Sand purchase from MALLE VENKATESHWARLU
\n","","","","cheque","2992","VENKATESH");
INSERT INTO expenses VALUES("9137","1","","","2016-12-26","116","28500","Paid to SHABBIR AHMED			
\n","","","","cheque","2990","Shabbir");
INSERT INTO expenses VALUES("9138","1","","","2016-12-22","119","5000","Architecture fees paid to his wife account. 			
\n","","","","cheque","2989","ZAKIYA BEGUM");
INSERT INTO expenses VALUES("9139","1","","","2016-12-30","93","600","Nadeem bhai have food in shan Bagh		
\n","","","","bank transfer","","SHANBHAGS");
INSERT INTO expenses VALUES("9140","1","","","2016-12-30","119","200","VPS/IOCL AMAR S/20161230130433/0","","","","cash",""," AMAR");
INSERT INTO expenses VALUES("9141","1","","","2016-11-18","118","169","Cash dep Chg Oct-16			
\n","","","","cash","","Bankers");
INSERT INTO expenses VALUES("9143","1","","","2016-11-22","119","1813","Nadeem bhai purchase from Balaji Grand.","","","","bank transfer","","BALAJI GRAND ");
INSERT INTO expenses VALUES("9144","1","","","2016-12-31","93","525","VPS/GRAND HOTEL/20161231231559/0			
\n","","","","bank transfer","","GRAND HOTEL");
INSERT INTO expenses VALUES("9145","1","","","2017-05-16","1","50000","CASH PAID:VENKAT	","","","","cheque","3109","VENKATESH");
INSERT INTO expenses VALUES("9146","1","","","2017-06-03","1","24000","CASH PAID:VENKATESH
\n","","","","cheque","3121","VENKATESH");
INSERT INTO expenses VALUES("9147","1","","","2017-06-23","1","30000","CASH PAID:VENKATH
\n","","","","cheque","3143","VENKATESH");
INSERT INTO expenses VALUES("9148","1","","","2017-06-29","1","4500","Paid to MALLE VENKATESHWARLU","","","","cheque","3203","VENKATESH");
INSERT INTO expenses VALUES("9149","1","","","2017-06-30","1","73000","NEFT:000028929800/MALLE VENKATESHWARLU","","","","cheque","3148","VENKATESH");
INSERT INTO expenses VALUES("9150","1","","","2017-06-03","116","49000","CASH PAID:SHABBER AHMED	
\n","","","","cheque","3195","Shabbir");
INSERT INTO expenses VALUES("9151","1","","","2017-06-06","116","54291","CASH PAID:AHMED
\n","","","","cheque","3196","Shabbir");
INSERT INTO expenses VALUES("9152","1","","","2017-06-09","116","15000","CASH PAID:SHABBIR AHMED
\n","","","","cheque","3122","Shabbir");
INSERT INTO expenses VALUES("9153","1","","","2017-06-15","116","30000","CASH PAID:SHABBIR AHMED	","","","","cheque","3135","Shabbir");
INSERT INTO expenses VALUES("9154","1","","","2017-06-29","116","50000","Cash paid: SHABBIR AHMED	
\n","","","","cheque","3147","Shabbir");
INSERT INTO expenses VALUES("9155","1","","","2017-06-12","116","2300","CASH PAID:AHMED	
\n","","","","cheque","3127","Shabbir");
INSERT INTO expenses VALUES("9157","1","","","2017-05-18","118","115","Chq book Chg Apr-17 + S Tax15.00
\n","","","","cash","","Bankers");
INSERT INTO expenses VALUES("9159","1","","","2017-05-22","115","558","Land line phone bill paid","","","","bank transfer","","Phone Bill");
INSERT INTO expenses VALUES("9160","1","","","2017-06-03","95","15292","Paid electricity bill
\n","","","","cheque","3194","Electricity bill ");
INSERT INTO expenses VALUES("9161","1","","","2017-06-13","14","64000","Transfer to NALLA VERRIYYA","","","","cheque","3125","Babu");
INSERT INTO expenses VALUES("9162","1","","","2017-06-03","2","60000","NEFT:000027709393/INDIA STEEL ENTERPRISES","","","","cheque","3116","JUNAID");
INSERT INTO expenses VALUES("9163","1","","","2016-12-19","119","50000","Amount paid for architecture drawing. Amount transfer nto his wife account TRFR TO:MUBEEM SHAREEF.","","","","cheque","2988","Waffi");
INSERT INTO expenses VALUES("9164","1","","","2016-12-22","119","50000","Amount paid for architecture drawing. Amount transfer nto his wife account TRFR TO:MUBEEM SHAREEF.","","","","cheque","2987","Waffi");
INSERT INTO expenses VALUES("9165","1","","","2016-12-22","119","18800","Dont remember 			
\n","","","","cheque","2991","RAGHUNATHA REDDY");
INSERT INTO expenses VALUES("9166","1","","","2016-12-28","119","2000","Dont remember.","","","","bank transfer","","SRI ANJA");
INSERT INTO expenses VALUES("9167","1","","","2016-12-29","119","25000","LRS fees paid for 2 plots","","","","cheque","2995","Ansari");
INSERT INTO expenses VALUES("9168","1","","","2016-12-31","111","650","Internet bill paid","","","","cheque","2997","COUNTRY ONLINE ");
INSERT INTO expenses VALUES("9169","1","","","2017-01-02","117","2165","Nadeem bhai purchase. total 3 entries in statement. we put one entry.","","","","bank transfer","","Purchase");
INSERT INTO expenses VALUES("9170","1","","","2017-01-03","117","6500","Total 4 entries in statement.","","","","bank transfer","","Purchase");
INSERT INTO expenses VALUES("9171","1","","","2017-01-05","117","17236","Total 3 entries in statement.","","","","bank transfer","","Purchase");
INSERT INTO expenses VALUES("9172","1","","","2017-06-17","2","40000","Purchase cement from INDIA STEEL ENTERPRISES.","","","","cheque","3139","JUNAID");
INSERT INTO expenses VALUES("9173","1","","","2017-06-28","2","18600","Purchase cement from INDIA STEEL ENTERPRISES.","","","","cheque","3144","JUNAID");
INSERT INTO expenses VALUES("9174","1","","","2017-05-20","9","30000","CASH PAID:SENU","","","","cheque","3110","Senu");
INSERT INTO expenses VALUES("9175","1","","","2017-06-03","9","50000","CASH PAID:SENU		
\n","","","","cheque","3118","Senu");
INSERT INTO expenses VALUES("9176","1","","","2017-06-05","119","650","Internet bill paid.","","","","cheque","3197","Country online");
INSERT INTO expenses VALUES("9177","1","","","2017-06-13","117","8000","CASH PAID:NADEEM","","","","cheque","3131","Nadeem bhai");
INSERT INTO expenses VALUES("9178","1","","","2017-06-13","119","6000","APLINES BOREWELLS AND PUM","","","","cheque","3192","xxx");
INSERT INTO expenses VALUES("9179","1","","","2017-04-12","2","52800","Purchase cement from INDIA STEEL ENTERPRISES.","","","","cheque","3079","JUNAID");
INSERT INTO expenses VALUES("9180","1","","","2017-05-02","2","62400","Purchase cement from INDIA STEEL ENTERPRISES.","","","","cheque","3092","JUNAID");
INSERT INTO expenses VALUES("9181","1","","","2017-05-11","2","63000","Purchase cement from INDIA STEEL ENTERPRISES.","","","","cheque","3106","JUNAID");
INSERT INTO expenses VALUES("9182","1","","","2017-05-03","114","120300","Purchase steel from H S M STEELS.","","","","cheque","3090","KESHREE METAL");
INSERT INTO expenses VALUES("9185","1","","","2017-04-29","1","50000","CASH PAID:VENKATH","","","","cheque","3088","VENKATESH");
INSERT INTO expenses VALUES("9186","1","","","2017-05-06","1","40000","Paid to: VENKATESH","","","","cheque","3096","VENKATESH");
INSERT INTO expenses VALUES("9187","1","","","2017-05-01","14","95400","Paid to VERRIYYA NALLA","","","","cheque","3082","Babu");
INSERT INTO expenses VALUES("9188","1","","","2017-02-08","119","5000","Cheque issued: Self","","","","cheque","3018","SELF");
INSERT INTO expenses VALUES("9189","1","","","2017-02-10","119","125000","Cheque issued: Self","","","","cheque","3021","SELF");
INSERT INTO expenses VALUES("9190","1","","","2017-02-10","119","200000","Cheque issued: Self","","","","cheque","3023","SELF");
INSERT INTO expenses VALUES("9191","1","","","2017-02-10","119","10000","Cheque issued: Self","","","","cheque","3022","SELF");
INSERT INTO expenses VALUES("9192","1","","","2017-02-13","119","24000","ATM/CASH WDL/11-02-17/0","","","","bank transfer","","SELF");
INSERT INTO expenses VALUES("9193","1","","","2017-02-14","119","400000","Cheque issued: Self","","","","cheque","3025","SELF");
INSERT INTO expenses VALUES("9194","1","","","2017-02-18","119","50000","Cheque issued: Self","","","","cheque","3027","SELF");
INSERT INTO expenses VALUES("9195","1","","","2017-02-18","119","50000","Cheque issued: Self","","","","cheque","3029","SELF");
INSERT INTO expenses VALUES("9196","1","","","2017-02-22","119","30000","Cheque issued: Self","","","","cheque","3035","SELF");
INSERT INTO expenses VALUES("9197","1","","","2017-03-10","119","75000","Cheque issued: Self","","","","cheque","3050","SELF");
INSERT INTO expenses VALUES("9198","1","","","2017-03-14","119","15000","Cheque issued: Self","","","","cheque","3053","SELF");
INSERT INTO expenses VALUES("9199","1","","","2017-03-03","119","25000","Cheque issued: Self","","","","cheque","3046","SELF");
INSERT INTO expenses VALUES("9200","1","","","2017-03-04","119","25000","TRFR TO:MOHD AZEEMUDDIN QURAISHI","","","","cheque","3041","SELF");
INSERT INTO expenses VALUES("9201","1","","","2017-01-02","119","1289","	VPS/QUALITY CAR/20170102115437/0	","","","","bank transfer","","QUALITY CAR");
INSERT INTO expenses VALUES("9202","1","","","2017-01-03","119","2000","VPS/PRASADS IMA/20170103193732/0	","","","","bank transfer","","PRASADS IMA");
INSERT INTO expenses VALUES("9203","1","","","2017-01-10","119","1233","VPS/QUALITY CAR","","","","bank transfer","","QUALITY CAR");
INSERT INTO expenses VALUES("9204","1","","","2017-02-10","120","10000","Salary paid to superviser","","","","cheque","3020","Kishore");
INSERT INTO expenses VALUES("9205","1","","","2017-03-06","120","15000","Paid salary","","","","cheque","3044","Kishore");
INSERT INTO expenses VALUES("9206","1","","","2017-02-18","119","50000","Hand loan return to Alam","","","","cheque","3030","Alam");
INSERT INTO expenses VALUES("9207","1","","","2017-02-24","119","10000","xxx","","","","cheque","3033","ABDUL HAKEEM");
INSERT INTO expenses VALUES("9208","1","","","2017-03-04","119","45000","xxx","","","","cheque","3040","ALEEM");
INSERT INTO expenses VALUES("9209","1","","","2017-03-17","119","10000","Hand loan given","","","","cheque","3057","Afzal");
INSERT INTO expenses VALUES("9210","1","","","2017-03-21","119","10000","Amount paid firm registration.","","","","cheque","3059","Balu");
INSERT INTO expenses VALUES("9211","1","","","2017-01-07","119","46000","Cheque issued: Self","","","","cheque","3000","SELF");
INSERT INTO expenses VALUES("9212","1","","","2017-01-10","119","20600","Cheque issued: Self","","","","cheque","3001","SELF");
INSERT INTO expenses VALUES("9213","1","","","2017-01-19","119","50000","Cheque issued: Self","","","","cheque","3003","SELF");
INSERT INTO expenses VALUES("9214","1","","","2017-01-20","119","4000","Cheque issued: Self","","","","cheque","3005","SELF");
INSERT INTO expenses VALUES("9215","1","","","2017-01-27","119","60000","	CASH PAID:SELF	3012	60,000.00	0.00				
\n","","","","cheque","3012","SELF");
INSERT INTO expenses VALUES("9216","1","","","2017-01-10","119","2206","VPS/CARE HOSPIT/20170110134641/0","","","","bank transfer","","CARE HOSPITAL");
INSERT INTO expenses VALUES("9217","1","","","2017-01-10","119","4284","VPS/KARACHI BAK/20170110151244/0	","","","","bank transfer","","KARACHI BAKERY");
INSERT INTO expenses VALUES("9218","1","","","2017-03-24","119","50000","Cheque issued: Self","","","","cheque","3066","SELF");
INSERT INTO expenses VALUES("9219","1","","","2017-03-24","119","30000","Cheque issued: Self","","","","cheque","3067","SELF");
INSERT INTO expenses VALUES("9220","1","","","2017-03-28","9","50000","Paid to: K SRINIVAS RAO","","","","cheque","3073","Senu");
INSERT INTO expenses VALUES("9221","1","","","2017-03-01","119","10023","NFS/CASH WDL/01-03-17","","","","bank transfer","","SELF");
INSERT INTO expenses VALUES("9222","1","","","2017-03-01","119","10023","NFS/CASH WDL/01-03-17/Fee Rs20.00 ST Rs3.00","","","","bank transfer","","SELF");
INSERT INTO expenses VALUES("9223","1","","","2017-03-01","119","10023","NFS/CASH WDL/01-03-17/Fee Rs20.00 ST Rs3.00	","","","","bank transfer","","SELF");
INSERT INTO expenses VALUES("9224","1","","","2017-03-01","119","10023","	NFS/CASH WDL/01-03-17/Fee Rs20.00 ST Rs3.00	","","","","bank transfer","","SELF");
INSERT INTO expenses VALUES("9225","1","","","2017-03-01","119","6023","NFS/CASH WDL/01-03-17/Fee Rs20.00 ST Rs3.00		","","","","bank transfer","","SELF");
INSERT INTO expenses VALUES("9226","1","","","2017-01-02","119","876","VPS/KARACHI BAK/20170102124207/0	","","","","bank transfer","","KARACHI BAKERY");
INSERT INTO expenses VALUES("9227","1","","","2017-01-03","119","40000","NFS/CASH WDL/03-01-17	","","","","bank transfer","","SELF");
INSERT INTO expenses VALUES("9228","1","","","2017-01-03","119","500","IPS/TOLICHOWKI /20170103224410/0	","","","","bank transfer","","SELF");
INSERT INTO expenses VALUES("9229","1","","","2017-01-05","119","16404","VPS/Brand Facto/20170105143232/0","","","","bank transfer","","Brand Factory");
INSERT INTO expenses VALUES("9230","1","","","2017-01-05","119","211","VPS/DHYANSAI FO/20170105232412/0	","","","","bank transfer","","SELF");
INSERT INTO expenses VALUES("9231","1","","","2017-01-06","119","650","VPS/SHAH GHOUSE/20170107031708/0","","","","bank transfer","","SHAH GHOUSE");
INSERT INTO expenses VALUES("9232","1","","","2017-01-09","119","100","VPS/TOLICHOWKI /20170109124057/0","","","","bank transfer","","VPS/TOLICHOWKI");
INSERT INTO expenses VALUES("9233","1","","","2017-01-09","119","1000","Transfer to SRI MAHALAK","","","","bank transfer","","SRI MAHALAK");
INSERT INTO expenses VALUES("9234","1","","","2017-01-11","119","2023","NFS/CASH WDL/11-01-17/Fee Rs20.00 ST Rs3.00		","","","","bank transfer","","SELF");
INSERT INTO expenses VALUES("9235","1","","","2017-01-12","119","760","VPS/SHANBHAG S /20170112170146/","","","","bank transfer","","SHANBHAG ");
INSERT INTO expenses VALUES("9236","1","","","2017-01-02","119","37700","Paid to: S R CONSTRUCTION","","","","cheque","2996","S R CONSTRUCTION");
INSERT INTO expenses VALUES("9237","1","","","2016-05-07","9","250000","Paid labour payment","","","","cash","","Senu");
INSERT INTO expenses VALUES("9238","1","","","2016-05-20","9","25000","Paid labour payment","","","","cash","","Senu");
INSERT INTO expenses VALUES("9239","1","","","2016-05-26","9","130000","Paid labour payment","","","","cash","","Senu");
INSERT INTO expenses VALUES("9240","1","","","2016-06-09","9","100000","Paid labour payment","","","","cash","","Senu");
INSERT INTO expenses VALUES("9241","1","","","2016-06-18","9","20000","Paid labour payment","","","","cash","","Senu");
INSERT INTO expenses VALUES("9242","1","","","2016-06-24","9","50000","Paid labour payment","","","","cash","","Senu");
INSERT INTO expenses VALUES("9243","1","","","2016-07-19","9","130000","Paid labour payment","","","","cash","","Senu");
INSERT INTO expenses VALUES("9244","1","","","2016-07-26","9","120000","Paid labour payment","","","","cash","","Senu");
INSERT INTO expenses VALUES("9245","1","","","2016-08-04","9","150000","Paid labour payment","","","","cash","","Senu");
INSERT INTO expenses VALUES("9246","1","","","2016-08-15","9","135000","Paid labour payment","","","","cash","","Senu");
INSERT INTO expenses VALUES("9247","1","","","2016-08-27","9","130000","Paid labour payment","","","","cash","","Senu");
INSERT INTO expenses VALUES("9248","1","","","2016-09-05","9","250000","Paid labour payment","","","","cash","","Senu");
INSERT INTO expenses VALUES("9249","1","","","2016-09-17","9","100000","Paid labour payment","","","","cash","","Senu");
INSERT INTO expenses VALUES("9250","1","","","2016-09-21","9","200000","Paid labour payment","","","","cash","","Senu");
INSERT INTO expenses VALUES("9251","1","","","2016-10-07","9","100000","Paid labour payment","","","","cash","","Senu");
INSERT INTO expenses VALUES("9252","1","","","2016-10-08","9","150000","Paid labour payment","","","","cash","","Senu");
INSERT INTO expenses VALUES("9253","1","","","2016-10-26","9","250000","Paid labour payment","","","","cash","","Senu");
INSERT INTO expenses VALUES("9254","1","","","2016-11-08","9","50000","Paid labour payment","","","","cash","","sen");
INSERT INTO expenses VALUES("9255","1","","","2016-11-14","9","100000","Paid labour payment","","","","cash","","Senu");
INSERT INTO expenses VALUES("9256","1","","","2016-12-16","9","25000","Paid labour payment","","","","cash","","Senu");
INSERT INTO expenses VALUES("9257","1","","","2016-12-31","9","100000","Paid labour payment","","","","cash","","Senu");
INSERT INTO expenses VALUES("9258","1","","","2017-03-27","9","50000","Paid labour payment","","","","cash","","Senu");
INSERT INTO expenses VALUES("9259","1","","","2017-05-24","9","100000","Paid labour payment","","","","cash","","Senu");
INSERT INTO expenses VALUES("9260","1","","","2017-05-03","9","50000","Paid labour payment","","","","cheque","3092","Senu");
INSERT INTO expenses VALUES("9261","1","","","2017-05-11","9","50000","Paid labour payment","","","","cheque","3105","Senu");
INSERT INTO expenses VALUES("9262","1","","","2017-05-22","9","50000","Paid labour payment","","","","cash","","Senu");
INSERT INTO expenses VALUES("9263","1","","","2017-06-06","9","10000","Paid labour payment","","","","cash","","Senu");
INSERT INTO expenses VALUES("9264","1","","","2017-06-14","9","50000","Paid labour payment","","","","cash","","Senu");
INSERT INTO expenses VALUES("9265","1","","","2017-05-12","119","20000","Cheque paid: Self","","","","cheque","3087","SELF");
INSERT INTO expenses VALUES("9266","1","","","2017-05-18","119","8000","Cheque paid: Self","","","","cheque","3107","SELF");
INSERT INTO expenses VALUES("9267","1","","","2017-05-26","119","50000","Cheque paid: Azeem","","","","cheque","3113","SELF");
INSERT INTO expenses VALUES("9268","1","","","2017-06-03","119","25000","TRFR TO:M AZEEMUDDIN QURAISHI","","","","cheque","3115","SELF");
INSERT INTO expenses VALUES("9269","1","","","2017-06-09","119","100000","Cheque paid: Self","","","","cheque","3123","SELF");
INSERT INTO expenses VALUES("9270","1","","","2017-05-04","77","4000","Purchase electrical material from MUKESH ELECTRICALS","","","","cheque","3191","DEVA");
INSERT INTO expenses VALUES("9271","1","","","2017-04-12","5","88184","Purchase sanitary material from SRI LAXMI SALES CORPORATI	","","","","cheque","3078","SRI LAXMI SANITARY");
INSERT INTO expenses VALUES("9272","1","","","2017-05-01","14","95400","Transfer to: VERRIYYA NALLA","","","","cheque","3082","Babu");
INSERT INTO expenses VALUES("9273","1","","","2017-05-10","14","62040","Transfer to: NALLA VERRIYYA	","","","","cheque","3100","Babu");
INSERT INTO expenses VALUES("9274","1","","","2017-05-08","115","511","Land line phone bill paid","","","","bank transfer","","Phone Bill");
INSERT INTO expenses VALUES("9275","1","","","2017-04-07","119","25000","TRFR TO:M AZEEMUDDIN QURAISHI","","","","cheque","3077","SELF");
INSERT INTO expenses VALUES("9276","1","","","2017-05-03","119","25000","Cheque paid to: Self","","","","cheque","3093","SELF");
INSERT INTO expenses VALUES("9277","1","","","2017-05-06","119","50000","Cheque paid to: Self. ","","","","cheque","3099","SELF");
INSERT INTO expenses VALUES("9278","1","","","2017-05-09","119","100000","Cheque paid to: Self.","","","","cheque","3101","SELF");
INSERT INTO expenses VALUES("9279","1","","","2017-05-11","119","25000","Cheque paid to: YASMEEN AFROZE","","","","cheque","3103","YASMEEN AFROZE");
INSERT INTO expenses VALUES("9280","1","","","2017-05-06","119","25000","TRFR TO:AZEEMUDDIN QUADRI","","","","cheque","3098","SELF");
INSERT INTO expenses VALUES("9281","1","","","2017-04-11","114","144963","Purchase steels from KESHREE METALURGIES P LTD","","","","cheque","3076","KESHREE METAL");
INSERT INTO expenses VALUES("9282","1","","","2017-06-13","5","5846","TRFR TO:J K SANITARY AND ELECTRICAL","","","","cheque","3199"," J K SANITARY AND ELECTRICAL");
INSERT INTO expenses VALUES("9283","1","","","2017-06-21","5","4300","TRFR TO:J K SANITARY & ELECTRICAL","","","","cheque","3201","J K SANITARY & ELECTRICAL");
INSERT INTO expenses VALUES("9284","1","","","2017-07-26","102","250000","TRFR TO:FZAMI ONLINE SERVICES","","","","cheque","3180","FZAMI ONLINE SERVICES");
INSERT INTO expenses VALUES("9285","1","","","2017-07-04","116","40000","CASH PAID:SHABBIR AHMED","","","","cheque","3151","Shabbir");
INSERT INTO expenses VALUES("9286","1","","","2017-07-05","116","7000","Cheque paid to: SHABBBIR AHMED","","","","cheque","3152","Shabbir");
INSERT INTO expenses VALUES("9287","1","","","2017-07-07","114","100000","Purchase steels from H S M STEELS","","","","cheque","3153","H S M STEELS");
INSERT INTO expenses VALUES("9288","1","","","2017-07-12","2","58000","Purchase cement from INDIA STEEL ENTERPRISES","","","","cheque","3161","JUNAID");
INSERT INTO expenses VALUES("9289","1","","","2017-07-21","2","57000","Purchase cement from INDIA STEEL ENTERPRISES","","","","cheque","3173","JUNAID");
INSERT INTO expenses VALUES("9290","1","","","2017-06-12","121","30000","Purchase lappum from company.","","","","cheque","3114","ALLTEK SECCOLOR");
INSERT INTO expenses VALUES("9291","1","","","2017-06-12","120","9500","Salary paid to Ramesh","","","","cheque","3128","Ramesh");
INSERT INTO expenses VALUES("9292","1","","","2017-07-03","14","129000","Paid to: NALLA  VERRIYYA ","","","","cheque","3207","Babu");
INSERT INTO expenses VALUES("9293","1","","","2017-07-25","14","100000","Paid to: NALLA VERRIYYA 	","","","","cheque","3177","Babu");
INSERT INTO expenses VALUES("9294","1","","","2017-07-03","115","513","Land line phone bill paid","","","","bank transfer","","Phone Bill");
INSERT INTO expenses VALUES("9295","1","","","2017-07-17","115","535","Land line phone bill paid.","","","","bank transfer","","Phone Bill");
INSERT INTO expenses VALUES("9296","1","","","2017-07-06","95","19889","Paid Electricity bill.","","","","cheque","3206","Electricity bill ");
INSERT INTO expenses VALUES("9297","1","","","2017-07-18","95","11009","Paid Electricity bill ","","","","cheque","3163","Electricity bill ");
INSERT INTO expenses VALUES("9298","1","","","2017-07-11","1","30000","Paid to 	VENKATESH	
\n","","","","cheque","3157","VENKATESH");
INSERT INTO expenses VALUES("9299","1","","","2017-07-15","1","50000","Paid to VENKATESH. ","","","","cheque","3172","VENKATESH");
INSERT INTO expenses VALUES("9300","1","","","2017-07-25","1","40000","CHEQUE PAID:M VENKATHWARLU	","","","","cheque","3178","VENKATESH");
INSERT INTO expenses VALUES("9301","1","","","2017-07-11","119","25000","TRFR TO:M AZEEMUDDIN QURASHI	","","","","cheque","3158","SELF");
INSERT INTO expenses VALUES("9302","1","","","2017-07-13","119","75000","Cheque paid to: Self","","","","cheque","3162","SELF");
INSERT INTO expenses VALUES("9303","1","","","2017-07-03","77","25200","Purchase Electrical material from MUKESH ELECTRICALS","","","","cheque","3149","DEVA");
INSERT INTO expenses VALUES("9304","1","","","2017-07-15","120","9500","Salary paid to Ramesh","","","","bank transfer","","Ramesh");
INSERT INTO expenses VALUES("9305","1","","","2017-07-26","119","909","Transfer to KARACHI BAKERY","","","","bank transfer","","KARACHI BAKERY");
INSERT INTO expenses VALUES("9306","1","","","2017-07-27","119","20000","Cheque paid to: Self.","","","","cheque","3182","SELF");
INSERT INTO expenses VALUES("9307","1","","","2017-07-28","119","25000","Cheque paid to: Self.","","","","cheque","3184","SELF");
INSERT INTO expenses VALUES("9308","1","","","2017-07-29","119","60000","Cheque paid to: Self.","","","","cheque","3185","SELF");
INSERT INTO expenses VALUES("9309","1","","","2017-08-02","119","25000","TRFR TO:M AZEEMUDDIN QURAISHI","","","","cheque","3190","SELF");
INSERT INTO expenses VALUES("9310","1","","","2017-08-11","119","10000","Cheque issued: Self.","","","","cheque","3218","SELF");
INSERT INTO expenses VALUES("9311","1","","","2017-08-24","119","34000","Cheque issued: Self.","","","","cheque","3232","SELF");
INSERT INTO expenses VALUES("9312","1","","","2017-08-28","119","100000","Cheque issued: Self.","","","","cheque","3236","SELF");
INSERT INTO expenses VALUES("9313","1","","","2017-09-22","119","100000","TRFR TO: FZAMI ONLINE SERVICES","","","","cheque","3291","FZAMI ONLINE SERVICES");
INSERT INTO expenses VALUES("9314","1","","","2017-09-19","10","25000","PAID TO: TIRUPATHI SWAMY","","","","cheque","3254","Trupatty");
INSERT INTO expenses VALUES("9315","1","","","2017-09-04","95","8176","Paid Electricity bill.","","","","cheque","3243","Electricity bill ");
INSERT INTO expenses VALUES("9316","1","","","2017-09-06","115","1384","Paid Land line bill (2 entries in one time done).","","","","bank transfer","","Phone Bill");
INSERT INTO expenses VALUES("9317","1","","","2017-09-22","115","1368","Paid Land line phone bill.","","","","bank transfer","","Phone Bill");
INSERT INTO expenses VALUES("9318","1","","","2017-08-03","1","45000","Transfer to:  VENKATESH       
\n","","","","cheque","3186","VENKATESH");
INSERT INTO expenses VALUES("9319","1","","","2017-08-11","1","46000","CHEQUE PAID:VENKETESHWARLU.","","","","cheque","3213","VENKATESH");
INSERT INTO expenses VALUES("9320","1","","","2017-09-12","1","44344","Transfer to: Venkatesh.","","","","cheque","3246","VENKATESH");
INSERT INTO expenses VALUES("9321","1","","","2017-09-12","1","56000","CHEQUE  PAID:Venkatesh","","","","cheque","3247","VENKATESH");
INSERT INTO expenses VALUES("9322","1","","","2017-08-08","114","100000","Paid to: H S M STEELS","","","","cheque","3210","H S M STEELS");
INSERT INTO expenses VALUES("9323","1","","","2017-08-09","2","55000","Purchase cement from INDIA STEEL ENTERPRISES.","","","","cheque","3211","JUNAID");
INSERT INTO expenses VALUES("9324","1","","","2017-08-29","2","53000","Purchase cement from INDIA STEEL ENTERPRISES.	","","","","cheque","3241","JUNAID");
INSERT INTO expenses VALUES("9325","1","","","2017-09-18","114","50000","Paid to: H S M STEELS","","","","cheque","3251","H S M STEELS");
INSERT INTO expenses VALUES("9326","1","","","2018-04-09","116","2950","Paid for door fitting charges.","","","","cheque","3499","Shabbir");
INSERT INTO expenses VALUES("9327","1","","","2018-04-09","5","28146","Paid amount towards purchase of material.","","","","cheque","3498","SRI LAXMI SANITARY");
INSERT INTO expenses VALUES("9328","1","","","2017-07-27","111","1300","Internet bill paid","","","","cheque","3181","Country online");
INSERT INTO expenses VALUES("9329","1","","","2017-04-12","119","20000","Paid for electricity meter.","","","","cheque","3075","Aleem");
INSERT INTO expenses VALUES("9330","1","","","2017-05-03","9","50000","Paid to: Senu","","","","cheque","3094","Senu");
INSERT INTO expenses VALUES("9331","1","","","2017-05-11","9","50000","Cheque issued: Mahboob ","","","","cheque","3104","Senu");
INSERT INTO expenses VALUES("9332","1","","","2017-04-28","95","18348","Paid  Electricity bill. ( AAO ERO A C GUARDS )","","","","cheque","3085","Electricity bill ");
INSERT INTO expenses VALUES("9333","1","","","2018-04-28","10","12000","CHEQUE  PAID TO:TIRUPATHI SWAMY.","","","","cheque","3084","Trupatty");
INSERT INTO expenses VALUES("9334","1","","","2017-06-13","98","7000","Dont remember.","","","","cheque","3134","Fazil");
INSERT INTO expenses VALUES("9335","1","","","2017-06-13","98","8000","Dont remember.","","","","cheque","3133","Sajid");
INSERT INTO expenses VALUES("9336","1","","","2017-06-13","98","3500","Paid to: Imran.","","","","cheque","3132","Imran");
INSERT INTO expenses VALUES("9337","1","","","2017-06-17","120","10000","Advance salary given.","","","","cheque","3137","Mahboob");
INSERT INTO expenses VALUES("9338","1","","","2017-06-28","119","19000","NEFT:000028800160/MUSTAFFA SIDDIQUI","","","","cheque","3145","Mustaffa siddiqui");
INSERT INTO expenses VALUES("9339","1","","","2017-06-29","98","3000","Paid to: Anand.","","","","cheque","3146","Anand");
INSERT INTO expenses VALUES("9340","1","","","2017-06-29","98","15000","TRFR TO:K TIRUPATHI SWAMY. But it was return back.","","","","cheque","3205","Trupatty");
INSERT INTO expenses VALUES("9341","1","","","2017-08-03","118","294","Dbt card Chg Jun-17.","","","","bank transfer","","Bankers");
INSERT INTO expenses VALUES("9342","1","","","2017-08-02","93","30000","TRFR TO:NIZAMUDDIN QURESHI NADEEM","","","","cheque","3187","Nadeem bhai");
INSERT INTO expenses VALUES("9343","1","","","2017-08-17","98","11000","Paid to: A P LINES BORE WELL AND P.","","","","cheque","3212"," BORE WELL");
INSERT INTO expenses VALUES("9344","1","","","2017-08-18","14","100000","Paid to: VERRIYYA NALLA.","","","","cheque","3219","Babu");
INSERT INTO expenses VALUES("9345","1","","","2017-08-24","5","112215","Purchase sanitary material from SRI LAXMI SALES CORPORAT.","","","","cheque","3228","SRI LAXMI SANITARY");
INSERT INTO expenses VALUES("9346","1","","","2017-08-30","77","30500","Purchase electrical material from Mukesh electricals.","","","","cheque","3244","DEVA");
INSERT INTO expenses VALUES("9347","1","","","2017-09-19","77","68000","Purchase electrical material from Mukesh electricals.","","","","cheque","3255","DEVA");
INSERT INTO expenses VALUES("9348","1","","","2018-04-24","2","25500","Cement purchase and hamali paid. NEFT:000044423204/INDIA STEEL ENTERPRISES	","","","","cheque","3503","Junaid");
INSERT INTO expenses VALUES("9349","1","","","2018-04-24","5","36000","Sanatary purchase.	TRFR TO: J K SANITARY & ELECTRICAL
\n","","","","bank transfer","","J K SANITARY");
INSERT INTO expenses VALUES("9350","1","","","2018-04-24","1","21000","Sand purchase and amount paid. TRFR TO: MALLE VENKATESHWARLU","","","","cheque","3501","VENKATESH");
INSERT INTO expenses VALUES("9351","1","","","2018-04-19","1","25000","Sand purchase. TRFR TO:M VENKATSWARLAU.","","","","cheque","3612","VENKATESH");
INSERT INTO expenses VALUES("9352","1","","","2018-04-17","5","30000","Sanatary purchase. TRFR TO:J K SAINTARY	
\n","","","","cheque","3611","J K SAINTARY");
INSERT INTO expenses VALUES("9353","1","","","2018-04-16","95","17121","Paid Electricity bill. TSSPDCL","","","","cheque","3608","Electricity bill ");
INSERT INTO expenses VALUES("9354","1","","","2018-04-13","120","9500","Salary paid. CASH PAID:RAMESH","","","","cheque","3609","Ramesh");
INSERT INTO expenses VALUES("9355","1","","","2018-04-10","119","15000","Amount paid for 3D design for broucher. TRFR TO: PEDDABOINA TIRUPATHI	","","","","cheque","3607","Tirupathi");
INSERT INTO expenses VALUES("9356","1","","","2018-04-09","1","50000","Sand purchase. TRFR TO:M VENKATESWARLU.","","","","cheque","3605","VENKATESH");
INSERT INTO expenses VALUES("9357","1","","","2018-04-07","77","11500","Electrical material purchase by yousuf .CASH PAID:mukesh	
\n","","","","cheque","3604","Yousuf");
INSERT INTO expenses VALUES("9358","1","","","2017-08-17","120","10000","Salary paid to: Ramesh.","","","","cheque","3222","Ramesh");
INSERT INTO expenses VALUES("9359","1","","","2017-09-29","77","3400","Purchase electrical material from Mukesh electricals.","","","","cheque","3260","DEVA");
INSERT INTO expenses VALUES("9360","1","","","2017-09-29","120","5000","CASH PAID:Ramesh	","","","","cheque","3265","Ramesh");
INSERT INTO expenses VALUES("9361","1","","","2017-10-07","2","53000","Purchase cement from INDIA STEEL ENTERPRISES.","","","","cheque","3270","JUNAID");
INSERT INTO expenses VALUES("9362","1","","","2017-10-11","114","65000","Purchase steels from H S M STEELS.","","","","cheque","3276","H S M STEELS");
INSERT INTO expenses VALUES("9363","1","","","2017-10-13","77","100000","Purchase electrical material from MUKESH ELECTRICALS.","","","","cheque","3277","DEVA");
INSERT INTO expenses VALUES("9364","1","","","2017-10-03","77","35000","Purchase electrical material from MUKESH ELECTRICALS.","","","","cheque","3266","DEVA");
INSERT INTO expenses VALUES("9365","1","","","2017-10-16","77","41000","Purchase electrical material from Mukesh electricals.","","","","cheque","3279","DEVA");
INSERT INTO expenses VALUES("9366","1","","","2017-10-26","77","53800","Purchase electrical material from Mukesh electricals.","","","","cheque","3290","DEVA");
INSERT INTO expenses VALUES("9367","1","","","2017-08-11","89","5000","Paid weekly labour payment.","","","","cheque","3215","Ibrahim");
INSERT INTO expenses VALUES("9368","1","","","2017-09-01","89","10000","Paid weekly labour payment","","","","cheque","3233","Ibrahim");
INSERT INTO expenses VALUES("9369","1","","","2017-10-21","1","30000","TRFR TO:MALLE VENKATESHWARLU","","","","cheque","3288","VENKATESH");
INSERT INTO expenses VALUES("9370","1","","","2017-10-05","14","50000","Paid to: VERRIYYA NALLA.","","","","cheque","3267","Babu");
INSERT INTO expenses VALUES("9371","1","","","2017-10-26","119","11688","Cheque issued: Self.","","","","cheque","3298","SELF");
INSERT INTO expenses VALUES("9372","1","","","2017-10-04","119","20000","Cheque issued: Self.","","","","cheque","3268","SELF");
INSERT INTO expenses VALUES("9373","1","","","2017-10-04","95","6965","Paid electricity bill.","","","","cheque","3258","Electricity bill ");
INSERT INTO expenses VALUES("9374","1","","","2017-10-25","121","47250","Purchase lappum from ALLTEK SECCOLOR.","","","","cheque","3301","ALLTEK SECCOLOR");
INSERT INTO expenses VALUES("9375","1","","","2017-10-13","120","5000","Paid to: Ramesh.","","","","cheque","3296","Ramesh");
INSERT INTO expenses VALUES("9376","1","","","2017-11-15","115","618","Paid Land line phone bill. (2 entries in one time done)","","","","bank transfer","","Phone Bill");
INSERT INTO expenses VALUES("9377","1","","","2018-11-02","95","12215","Paid electricity bill.","","","","cheque","3308","Electricity bill ");
INSERT INTO expenses VALUES("9378","1","","","2017-11-17","95","5981","Paid electricity bill.","","","","cheque","3333","Electricity bill ");
INSERT INTO expenses VALUES("9379","1","","","2017-11-15","77","41500","Purchase electrical material from Mukesh eletricals.","","","","cheque","3338","DEVA");
INSERT INTO expenses VALUES("9380","1","","","2017-11-17","77","16430","Purchase electrical material from Mukesh eletricals.","","","","cheque","3339","DEVA");
INSERT INTO expenses VALUES("9381","1","","","2017-11-30","77","3600","Purchase electrical material from Mukesh eletricals.","","","","cheque","3349","DEVA");
INSERT INTO expenses VALUES("9382","1","","","2017-09-29","116","10000","Paid to: Shabbir Ahmed.","","","","cheque","3264","Shabbir");
INSERT INTO expenses VALUES("9383","1","","","2017-10-31","2","52500","Purchase steel from INDIA STEEL ENTERPRISES.","","","","cheque","3309","JUNAID");
INSERT INTO expenses VALUES("9384","1","","","2017-12-15","2","101450","Purchase steel from INDIA STEEL ENTERPRISES.","","","","cheque","3366","JUNAID");
INSERT INTO expenses VALUES("9385","1","","","2017-10-31","1","30000","Sand purchase  amt. TRFR TO:MALLE VENKATESHWARLU.","","","","cheque","3314","VENKATESH");
INSERT INTO expenses VALUES("9386","1","","","2017-12-07","1","10000","Sand purchase  amt. TRFR TO:MALLE VENKATESHWARLU.","","","","cheque","3359","VENKATESH");
INSERT INTO expenses VALUES("9387","1","","","2017-10-31","89","10000","Flat waterproofing + Muradnagar work done.","","","","cheque","3312","Ibrahim");
INSERT INTO expenses VALUES("9388","1","","","2017-10-30","119","25000","Paid to ULTRA DENTAL HOSPITAL.","","","","cheque","3282","ULTRA DENTAL HOSPITAL.");
INSERT INTO expenses VALUES("9389","1","","","2017-11-21","119","145000","Cheque issued on Self.","","","","cheque","3342","SELF");
INSERT INTO expenses VALUES("9390","1","","","2017-11-29","119","20000","Cheque issued: Self.","","","","cheque","3347","SELF");
INSERT INTO expenses VALUES("9391","1","","","2017-11-01","5","94230","Purchase sanitary material from SRI LAXMI SALES CORPORAT.","","","","cheque","3307","SRI LAXMI SALES CORPORAT");
INSERT INTO expenses VALUES("9392","1","","","2017-12-01","5","30454","Purchase sanitary material from SRI LAXMI SALES CORPORAT.","","","","cheque","3344","SRI LAXMI SANITARY");
INSERT INTO expenses VALUES("9393","1","","","2017-12-06","116","30000","PAID:SHABBIR AHMED.","","","","cheque","3356","Shabbir");
INSERT INTO expenses VALUES("9394","1","","","2017-12-04","120","9500","Paid to: Ramesh.","","","","cheque","3334","Ramesh");
INSERT INTO expenses VALUES("9395","1","","","2017-12-04","120","10000","Paid to: Ramesh.","","","","cheque","3355","Ramesh");
INSERT INTO expenses VALUES("9396","1","","","2017-11-07","5","4000","Purchase sanitary material from  J K SANITARY.","","","","cheque","3320","J K SANITARY");
INSERT INTO expenses VALUES("9397","1","","","2017-10-31","9","20000","Paid weekly labour payment.","","","","cheque","3313","Senu");
INSERT INTO expenses VALUES("9398","1","","","2017-11-10","120","4000","Salary paid to Mahboob.","","","","cheque","3326","Mahboob");
INSERT INTO expenses VALUES("9399","1","","","2017-10-31","120","8000","Salary paid to Amair.","","","","cheque","3310","Amair");
INSERT INTO expenses VALUES("9400","1","","","2017-11-30","120","8000","Salary paid to Amair.","","","","cheque","3350","Amair");
INSERT INTO expenses VALUES("9401","1","","","2017-12-08","120","5000","Paid to: Mahboob.","","","","cheque","3360","Mahboob");
INSERT INTO expenses VALUES("9402","1","","","2017-11-08","102","150000","TRFR TO: FZAMI ONLINE SERVICES.","","","","cheque","3323"," FZAMI ONLINE SERVICES");
INSERT INTO expenses VALUES("9403","1","","","2017-11-15","102","50000","TRFR TO: FZAMI ONLINE SERVICES.","","","","cheque","3335","FZAMI ONLINE SERVICES");
INSERT INTO expenses VALUES("9404","1","","","2017-11-09","14","55000","Paid to: VERRIYYA NALLA.","","","","cheque","3315","Babu");
INSERT INTO expenses VALUES("9405","1","","","2017-12-26","1","30901","TRFR TO:M VENKATESHWARLU	.","","","","cheque","3371","VENKATESH");
INSERT INTO expenses VALUES("9406","1","","","2017-12-26","1","35753","TRFR TO:M VENKATESHWARLU.","","","","cheque","3370","VENKATESH");
INSERT INTO expenses VALUES("9407","1","","","2017-12-26","95","7403","Paid electricity bill.","","","","cheque","3367","Electricity bill ");
INSERT INTO expenses VALUES("9408","1","","","2018-01-20","102","150000","TRFR TO:FZAMI ONLINE SREVICES.","","","","cheque","3399","FZAMI ONLINE SERVICES");
INSERT INTO expenses VALUES("9409","1","","","2018-01-03","77","100000","Purchase electrical material from MUKESH ELECTRICALS.","","","","cheque","3373","DEVA");
INSERT INTO expenses VALUES("9410","1","","","2018-01-12","77","50000","Purchase electrical material from MUKESH ELECTRICALS.","","","","cheque","3390","DEVA");
INSERT INTO expenses VALUES("9411","1","","","2018-01-10","119","10000","Cheque issued: Self.","","","","cheque","3379","SELF");
INSERT INTO expenses VALUES("9412","1","","","2018-01-17","5","6100","Purchase sanitary material from  J K SANITARY.","","","","cheque","3391","J K SANITARY");
INSERT INTO expenses VALUES("9413","1","","","2018-01-20","95","5730","Paid electricity bill.","","","","cheque","3392","Electricity bill ");
INSERT INTO expenses VALUES("9414","1","","","2018-02-01","120","5000","Paid salary to Mahboob.","","","","cheque","3484","Mahboob");
INSERT INTO expenses VALUES("9415","1","","","2018-02-06","1","20000","TRFR TO: MALLE VENKATESHWARLU.","","","","cheque","3416","VENKATESH");
INSERT INTO expenses VALUES("9416","1","","","2018-02-06","2","54600","Purchase cement from INDIA STEEL ENTERPRISES.","","","","cheque","3417","JUNAID");
INSERT INTO expenses VALUES("9417","1","","","2018-02-07","5","8243","Purchase sanitary material from  J K SANITARY & ELECTRICAL.	
\n
\n","","","","cheque","3418","J K SANITARY");
INSERT INTO expenses VALUES("9418","1","","","2018-02-07","121","47250","Purchase lappum from ALLTEK SECCOLOR.","","","","cheque","3414","ALLTEK SECCOLOR");
INSERT INTO expenses VALUES("9419","1","","","2018-02-09","120","10000","Paid to: Ramesh.","","","","cheque","3423","Ramesh");
INSERT INTO expenses VALUES("9420","1","","","2018-02-17","9","30000","Paid weekly labour payment.","","","","cheque","3435","Senu");
INSERT INTO expenses VALUES("9421","1","","","2018-02-17","119","25000","Paid to; Azeem.","","","","cheque","3475","SELF");
INSERT INTO expenses VALUES("9422","1","","","2018-01-10","77","274312","Paid DD for Transformer new meter.","","","","cheque","3380","TSSPDCL");
INSERT INTO expenses VALUES("9423","1","","","2018-01-10","119","10000","Paid to: Shiva.","","","","cheque","3382","Shiva");
INSERT INTO expenses VALUES("9424","1","","","2018-01-20","119","20000","Paid to: Ahmed Basha.","","","","cheque","3398","Ahmed Basha");
INSERT INTO expenses VALUES("9425","1","","","2018-01-20","103","50000","Tiles purchase from Patel.","","","","cheque","3402","Patel");
INSERT INTO expenses VALUES("9426","1","","","2018-01-29","119","50000","Paid to: Shafi.","","","","cheque","3404","Shafi");
INSERT INTO expenses VALUES("9427","1","","","2018-01-30","119","14000","Paid to: Afzal.","","","","cheque","3407","Afzal");
INSERT INTO expenses VALUES("9428","1","","","2018-01-29","119","10000","Withdraw Amt. for Yousuf  but used for other expenditure.","","","","cheque","3489","Yousuf");
INSERT INTO expenses VALUES("9429","1","","","2018-02-03","122","18300","Purchase ROBO SAND from Ravi.","","","","cheque","3412","Ravi");
INSERT INTO expenses VALUES("9430","1","","","2018-02-02","103","50000","Tiles purchase from Patel.","","","","cheque","3482","Patel");
INSERT INTO expenses VALUES("9431","1","","","2018-02-16","103","5000","Tiles purchase from Patel.","","","","cheque","3431","Patel");
INSERT INTO expenses VALUES("9432","1","","","2018-02-16","103","4500","Tiles purchase from Patel.","","","","cheque","3433","Patel");
INSERT INTO expenses VALUES("9433","1","","","2018-02-09","14","17000","Purchase RED BRICKS from Basith.","","","","cheque","3422","Basith");
INSERT INTO expenses VALUES("9434","1","","","2018-02-14","98","10000","Paid for material shifting.","","","","cheque","2429","Trupatty");
INSERT INTO expenses VALUES("9435","1","","","2018-02-09","121","9000","Paint material purchase.","","","","cheque","3421","Afsar");
INSERT INTO expenses VALUES("9436","1","","","2018-02-12","122","7500","Purchase ROBO SAND from Ravi.","","","","cheque","3426","Ravi");
INSERT INTO expenses VALUES("9437","1","","","2018-02-03","18","4000","Paid labour payment.","","","","cheque","3411","Krishna labour");
INSERT INTO expenses VALUES("9438","1","","","2018-02-05","13","4000","Material lifting charges.","","","","cheque","3415","Aqtar labour");
INSERT INTO expenses VALUES("9439","1","","","2018-02-17","121","10000","Purchase paint material.","","","","cheque","3476","Afsar");
INSERT INTO expenses VALUES("9440","1","","","2018-02-19","103","10000","Tiles purchase from Patel.","","","","cheque","3474","Patel");
INSERT INTO expenses VALUES("9441","1","","","2018-02-26","122","13500","Robo Sand purchase from Ravi.","","","","cheque","3469","Ravi");
INSERT INTO expenses VALUES("9442","1","","","2018-02-26","9","22000","Paid labour payment.","","","","cheque","3465","Senu");
INSERT INTO expenses VALUES("9443","1","","","2018-02-27","5","38800","Purchase sanitary material from  J K SANITARY.","","","","cheque","3471","J K SANITARY");
INSERT INTO expenses VALUES("9444","1","","","2018-02-27","77","30000","Purchase electrical material from Mukesh Electricals.","","","","cheque","3462","DEVA");
INSERT INTO expenses VALUES("9445","1","","","2018-02-27","1","30000","TRFR TO: MALLE VENKATESHWARLU.","","","","cheque","3463","VENKATESH");
INSERT INTO expenses VALUES("9446","1","","","2018-02-28","119","50000","Cheque issued: Self.","","","","cheque","3453","SELF");
INSERT INTO expenses VALUES("9447","1","","","2018-03-01","114","281600","Purchase steel from  H S M STEELS.","","","","cheque","3464","H S M STEELS");
INSERT INTO expenses VALUES("9448","1","","","2018-03-01","14","85656","Paid to: VERRIYYA NALLA.","","","","cheque","3460","Babu");
INSERT INTO expenses VALUES("9449","1","","","2018-03-17","118","118","Chq book Chg Feb-18+ GST.","","","","bank transfer","","Bankers");
INSERT INTO expenses VALUES("9450","1","","","2018-03-19","118","885","Chq rtn Chg Feb-18+ GST.","","","","bank transfer","","Bankers");
INSERT INTO expenses VALUES("9451","1","","","2018-03-01","114","281600","Purchase Steel from H S M STEELS.","","","","cheque","3464","H S M STEELS");
INSERT INTO expenses VALUES("9452","1","","","2018-03-23","2","52000","Purchase cement from INDIA STEEL ENTERPRISES.	","","","","cheque","3496","Junaid");
INSERT INTO expenses VALUES("9453","1","","","2018-03-01","14","85656","Paid to: NALLA VERRIYYA.	","","","","cheque","3460","Babu");
INSERT INTO expenses VALUES("9454","1","","","2018-03-02","5","60000","Purchase sanitary material from SRI LAKSHMI SALES CORPORATION.","","","","cheque","3450","SRI LAXMI SANITARY");
INSERT INTO expenses VALUES("9455","1","","","2018-03-02","103","50000","Tiles purchase from Patel.","","","","cheque","3445","Patel");
INSERT INTO expenses VALUES("9456","1","","","2018-03-07","121","5000","Paint material purchase from Afsar.","","","","cheque","3594","Afsar");
INSERT INTO expenses VALUES("9457","1","","","2018-03-23","119","24000","Cheque issued on Azeem.","","","","cheque","3492","SELF");
INSERT INTO expenses VALUES("9458","1","","","2017-07-15","119","20000","Cheque issued to IFTEQAR UNNISA.","","","","cheque","3171","IFTEQAR UNNISA	");
INSERT INTO expenses VALUES("9459","1","","","2017-09-29","120","4800","Cheque paid to Amair.","","","","cheque","3262","Amair");
INSERT INTO expenses VALUES("9460","1","","","2017-10-21","121","7500","Paint material purchase from Afsar.","","","","cheque","3289","Afsar");
INSERT INTO expenses VALUES("9461","1","","","2017-10-20","121","10000","Purchase paint material .","","","","cheque","3281","Afsar");



DROP TABLE investments;

CREATE TABLE `investments` (
  `id` int(7) NOT NULL AUTO_INCREMENT,
  `investor` int(3) NOT NULL,
  `date` date NOT NULL,
  `amount` float NOT NULL,
  `particulars` varchar(100) NOT NULL,
  `payment_method` enum('cash','cheque','bank transfer') NOT NULL,
  `payment_details` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=115 DEFAULT CHARSET=latin1;

INSERT INTO investments VALUES("17","6","2018-01-10","1000000","Received Rs 10,00,000/- ten lakhs. Total amount in fzami is Rs 13 lakhs. ","bank transfer","");
INSERT INTO investments VALUES("18","8","2018-05-02","500000","Taken loan from Laiba Educational Society (Canara Bank).","bank transfer","");
INSERT INTO investments VALUES("19","10","2016-06-10","500000","Cash deposite in bank to give payment to Rank Silicon.","cash","");
INSERT INTO investments VALUES("20","10","2016-06-07","100000","For opening of Sweet Homes account.","cash","");
INSERT INTO investments VALUES("22","10","2016-08-08","500000","By cash","cash","");
INSERT INTO investments VALUES("24","10","2016-08-01","500000","By cash","cash","");
INSERT INTO investments VALUES("26","10","2016-09-17","700000","By cash","cash","");
INSERT INTO investments VALUES("27","10","2016-09-19","175000","BY CASH - MEHDIPATNAM","cash","");
INSERT INTO investments VALUES("28","10","2016-09-19","500","By cash","cash","");
INSERT INTO investments VALUES("32","10","2016-10-13","365000","By cash","cash","");
INSERT INTO investments VALUES("35","10","2017-03-30","200000","BY CASH - HYDERABAD - TOLICHOWKI","cash","");
INSERT INTO investments VALUES("42","11","2016-08-17","70000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("43","11","2016-12-19","180000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("44","11","2016-12-22","120000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("45","11","2016-12-27","150000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("46","11","2017-01-06","300000","TRFR FROM:FZAMI ONLINE  SERVICES","bank transfer","");
INSERT INTO investments VALUES("47","10","2017-01-27","40000","BIL/001134645051/Sweet homes/NSP","cash","");
INSERT INTO investments VALUES("48","11","2017-02-03","666813","TRFR FROM:FZAMI ONLINES SERVICES","bank transfer","");
INSERT INTO investments VALUES("49","11","2017-02-10","400000","TRFR FROM:FZAMI ONLINE SERVICES","bank transfer","");
INSERT INTO investments VALUES("50","8","2017-02-13","500000","HANNAN YOUSUF QSBH  111786","bank transfer","");
INSERT INTO investments VALUES("51","11","2017-02-18","500000","TRFR FROM:FZAMI ONLINE SERVICES","bank transfer","");
INSERT INTO investments VALUES("52","11","2017-02-22","500000","TRFR FROM:FZAMI ONLINE","bank transfer","");
INSERT INTO investments VALUES("53","11","2017-03-06","250000","TRFR FROM:FZAMI ONLINE SERVICES","bank transfer","");
INSERT INTO investments VALUES("54","11","2017-03-10","125000","TRFR FROM:FZAMI ONLINE SERVICES","bank transfer","");
INSERT INTO investments VALUES("55","11","2017-03-14","500000","TRFR FROM:FZAMI ONLINE SERVICES
\n","bank transfer","");
INSERT INTO investments VALUES("56","11","2017-03-24","300000","TRFR FROM:FZAMI ONLINE SERVICES","bank transfer","");
INSERT INTO investments VALUES("57","11","2017-03-30","100000","TRFR FROM:FZAMI ONLINE SERVICES","bank transfer","");
INSERT INTO investments VALUES("66","11","2017-04-12","80000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("67","11","2017-04-25","500000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("68","11","2017-04-29","200000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("69","11","2017-05-03","130000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("70","11","2017-05-06","700000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("71","10","2017-04-07","200000","By cash - Hyderabad Tolichowki","bank transfer","");
INSERT INTO investments VALUES("72","11","2017-05-26","100000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("73","11","2017-06-01","500000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("74","11","2017-06-09","400000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("75","11","2017-06-17","40000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("76","11","2017-06-20","500000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("77","11","2017-07-01","200000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("78","11","2017-07-06","100000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("80","11","2017-07-11","1000000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("81","11","2017-08-02","500000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("82","11","2017-08-11","200000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("83","11","2017-08-16","800000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("84","11","2017-09-08","200000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("85","11","2017-09-12","75000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("86","11","2017-09-15","500000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("87","11","2017-09-29","500000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("88","11","2017-10-11","100000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("89","11","2017-10-16","500000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("90","11","2017-10-30","400000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("91","11","2017-11-29","500000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("92","10","2017-10-26","11688","By cash - Hyderabad Tolichowki","bank transfer","");
INSERT INTO investments VALUES("94","10","2018-01-10","10000","By cash - Hyderabad Tolichowki","bank transfer","");
INSERT INTO investments VALUES("95","11","2018-01-31","500000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("96","11","2018-02-09","400000","Transfer from FZAMI ONLINE SERVICE
\n","bank transfer","");
INSERT INTO investments VALUES("97","11","2018-02-23","500000","Transfer from FZAMI ONLINE SERVICE
\n","bank transfer","");
INSERT INTO investments VALUES("98","11","2018-02-27","200000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("99","11","2018-03-06","200000","Transfer from FZAMI ONLINE SERVICE","bank transfer","");
INSERT INTO investments VALUES("100","10","2017-07-14","75000","Cash Deposited in Bank.","cash","");
INSERT INTO investments VALUES("101","8","2017-10-07","53000","NEFT-RETURN-000033567646-INDIA STEEL ENTERPRISES-","bank transfer","");
INSERT INTO investments VALUES("102","8","2017-11-06","500000","VJB             VJB   634376","bank transfer","");
INSERT INTO investments VALUES("103","8","2017-11-07","200000","SYB            SYB  171225","bank transfer","");
INSERT INTO investments VALUES("104","7","2017-12-15","200000","TRFR FROM:AL AZEEM DAIRY","bank transfer","");
INSERT INTO investments VALUES("105","7","2017-12-22","200000","TRFR FROM:AL AZEEM DAIRY","bank transfer","");
INSERT INTO investments VALUES("106","8","2018-01-02","30000","TRFR FROM: MOHAMMAD NIZAMUDDIN QURESHI NADEEM JT1","bank transfer","");
INSERT INTO investments VALUES("107","8","2018-01-19","200000","SYB            SYB  705057","bank transfer","");
INSERT INTO investments VALUES("108","8","2018-01-19","100000","SYB            SYB  705059","bank transfer","");
INSERT INTO investments VALUES("109","8","2018-02-27","1000000","VIJAYA BANK/279304/VJB. Loan from Afaq.","bank transfer","");
INSERT INTO investments VALUES("110","8","2018-03-23","200000","TRFR FROM: HAPPY SCHOLAR","bank transfer","");
INSERT INTO investments VALUES("111","11","2018-04-06","500000","Amount transfer from Fzami.","bank transfer","");
INSERT INTO investments VALUES("112","11","2018-04-09","100000","TRFR FROM:FZAMI ONLINE SERVICES","bank transfer","");
INSERT INTO investments VALUES("113","11","2018-04-16","60000","TRFR FROM: FZAMI ONLINE SERVICES","bank transfer","");
INSERT INTO investments VALUES("114","8","2018-04-24","100000","TRFR FROM: HAPPY SCHOLAR. Loan taken.","bank transfer","");



DROP TABLE investor;

CREATE TABLE `investor` (
  `id` int(3) NOT NULL AUTO_INCREMENT,
  `name` varchar(25) NOT NULL,
  `phone` bigint(12) NOT NULL,
  `address` varchar(30) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=latin1;

INSERT INTO investor VALUES("6","WIRE THRU BANK","9030747606","ICICI BANK.");
INSERT INTO investor VALUES("7","BABU PATEL","8686147088","CASH.");
INSERT INTO investor VALUES("8","LOAN","12","HYD");
INSERT INTO investor VALUES("9","GOWAY","0","Canada");
INSERT INTO investor VALUES("10","CASH DEPOSITE","8686147088","Tolichowki.");
INSERT INTO investor VALUES("11","FZAMI TRANSFER","786","Hyderabad");



DROP TABLE project;

CREATE TABLE `project` (
  `id` int(3) NOT NULL AUTO_INCREMENT,
  `project_name` varchar(40) NOT NULL,
  `no_floors` int(2) NOT NULL,
  `start_date` date NOT NULL,
  `project_address` varchar(40) NOT NULL,
  `project_details` varchar(120) NOT NULL,
  `photo` varchar(30) NOT NULL,
  `no_flats` int(3) NOT NULL,
  `flats` varchar(200) NOT NULL,
  `type` enum('mt','ct') NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;

INSERT INTO project VALUES("9","Azeem Heights","5","2017-01-30","Mehdipatnam","370 Sq Yds","","15","101 - 503","ct");



DROP TABLE user;

CREATE TABLE `user` (
  `id` int(1) NOT NULL AUTO_INCREMENT,
  `username` varchar(15) NOT NULL,
  `password` varchar(10) NOT NULL,
  `email` varchar(25) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO user VALUES("1","admin","admin123","");



DROP TABLE work_type;

CREATE TABLE `work_type` (
  `id` int(3) NOT NULL AUTO_INCREMENT,
  `work_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=123 DEFAULT CHARSET=latin1;

INSERT INTO work_type VALUES("1","SAND");
INSERT INTO work_type VALUES("2","CEMENT");
INSERT INTO work_type VALUES("5","SANITARY");
INSERT INTO work_type VALUES("8","DOOR FRAMES");
INSERT INTO work_type VALUES("9","SENU (Labour payment)");
INSERT INTO work_type VALUES("10","TRUPATTY (Labour payment)");
INSERT INTO work_type VALUES("11","REDDY MIX");
INSERT INTO work_type VALUES("12","PIN AND VIBRATOR");
INSERT INTO work_type VALUES("13","DEPARTMENT LABOUR");
INSERT INTO work_type VALUES("14","BRICKS");
INSERT INTO work_type VALUES("18","CHIPPING LABOUR & GOA MAKING");
INSERT INTO work_type VALUES("29","KANKAR 20MM");
INSERT INTO work_type VALUES("30","KANKAR 60MM");
INSERT INTO work_type VALUES("77","ELECTRICAL MATERIAL");
INSERT INTO work_type VALUES("89","WATER PROFFING");
INSERT INTO work_type VALUES("93","NADEEM PERSONAL");
INSERT INTO work_type VALUES("95","ELECTRICITY BILL");
INSERT INTO work_type VALUES("97","PAINTER");
INSERT INTO work_type VALUES("98","MISCELLANEOUS");
INSERT INTO work_type VALUES("99","ELECTRICIAN");
INSERT INTO work_type VALUES("100","POP WORK");
INSERT INTO work_type VALUES("101","PLUMBER");
INSERT INTO work_type VALUES("102","FZAMI ONLINE SERVICES");
INSERT INTO work_type VALUES("103","TILES PURCHASE");
INSERT INTO work_type VALUES("104","GRANITE FITTING ");
INSERT INTO work_type VALUES("105","ALUMINIUM FITTING");
INSERT INTO work_type VALUES("107","TILES FITTING");
INSERT INTO work_type VALUES("110","LIFT ");
INSERT INTO work_type VALUES("111","INTERNET");
INSERT INTO work_type VALUES("112","ZAKI PLUMBER");
INSERT INTO work_type VALUES("113","GRANITE PURCHASE");
INSERT INTO work_type VALUES("114","STEELS");
INSERT INTO work_type VALUES("115","TATA BILLS");
INSERT INTO work_type VALUES("116","CARPENTER");
INSERT INTO work_type VALUES("117","NADEEM BHAI PERSONAL");
INSERT INTO work_type VALUES("118","BANK CHARGES");
INSERT INTO work_type VALUES("119","ONE TIME PAYMENT");
INSERT INTO work_type VALUES("120","SALARIES");
INSERT INTO work_type VALUES("121","PAINT MATERIAL");
INSERT INTO work_type VALUES("122","ROBO SAND");



